/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.contract.stubrunner.GitResource;
import org.springframework.cloud.contract.stubrunner.GitStubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public final class ScmStubDownloaderBuilder
implements StubDownloaderBuilder {
    private static final List<String> ACCEPTABLE_PROTOCOLS = Collections.singletonList("git");

    public static boolean isProtocolAccepted(String url) {
        return ACCEPTABLE_PROTOCOLS.stream().anyMatch(url::startsWith);
    }

    @Override
    public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.getStubsMode() == StubRunnerProperties.StubsMode.CLASSPATH || stubRunnerOptions.getStubRepositoryRoot() == null) {
            return null;
        }
        Resource resource = stubRunnerOptions.getStubRepositoryRoot();
        if (!(resource instanceof GitResource)) {
            return null;
        }
        return new GitStubDownloader(stubRunnerOptions);
    }

    @Override
    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (StringUtils.isEmpty((Object)location) || !ScmStubDownloaderBuilder.isProtocolAccepted(location)) {
            return null;
        }
        return new GitResource(location);
    }
}

