/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;

public class Body
extends DslProperty {
    public Body(Map<String, DslProperty> body) {
        super(Body.extractValue(body, ContractUtils.CLIENT_VALUE), Body.extractValue(body, ContractUtils.SERVER_VALUE));
    }

    public Body(List<DslProperty> bodyAsList) {
        super(bodyAsList.stream().map(DslProperty::getClientValue).collect(Collectors.toList()), bodyAsList.stream().map(DslProperty::getServerValue).collect(Collectors.toList()));
    }

    public Body(Object value) {
        super(ContractUtils.CLIENT_VALUE.apply(value), ContractUtils.SERVER_VALUE.apply(value));
    }

    public Body(Byte[] bodyAsValue) {
        super(bodyAsValue);
    }

    public Body(Number bodyAsValue) {
        super(bodyAsValue);
    }

    public Body(String bodyAsValue) {
        super(bodyAsValue, bodyAsValue);
    }

    public Body(DslProperty bodyAsValue) {
        super(bodyAsValue.getClientValue(), bodyAsValue.getServerValue());
    }

    public Body(Serializable serializable) {
        super(serializable, serializable);
    }

    public Body(MatchingStrategy matchingStrategy) {
        super(matchingStrategy, matchingStrategy);
    }

    private static Map<String, Object> extractValue(Map<String, DslProperty> body, Function valueProvider) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        body.forEach((key, value) -> map.put((String)key, valueProvider.apply(value)));
        return map;
    }
}

