/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import shaded.org.apache.maven.model.Dependency;
import shaded.org.apache.maven.model.DependencyManagement;
import shaded.org.apache.maven.model.DistributionManagement;
import shaded.org.apache.maven.model.Exclusion;
import shaded.org.apache.maven.model.License;
import shaded.org.apache.maven.model.Model;
import shaded.org.apache.maven.model.Prerequisites;
import shaded.org.apache.maven.model.Repository;
import shaded.org.apache.maven.repository.internal.ArtifactDescriptorUtils;

public class ArtifactDescriptorReaderDelegate {
    public void populateResult(RepositorySystemSession session, ArtifactDescriptorResult result, Model model) {
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for (Repository r : model.getRepositories()) {
            result.addRepository(ArtifactDescriptorUtils.toRemoteRepository(r));
        }
        for (Dependency dependency : model.getDependencies()) {
            result.addDependency(this.convert(dependency, stereotypes));
        }
        DependencyManagement mngt = model.getDependencyManagement();
        if (mngt != null) {
            for (Dependency dependency : mngt.getDependencies()) {
                result.addManagedDependency(this.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Prerequisites prerequisites = model.getPrerequisites();
        if (prerequisites != null) {
            properties.put("prerequisites.maven", prerequisites.getMaven());
        }
        List<License> licenses = model.getLicenses();
        properties.put("license.count", licenses.size());
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            properties.put("license." + i + ".name", license.getName());
            properties.put("license." + i + ".url", license.getUrl());
            properties.put("license." + i + ".comments", license.getComments());
            properties.put("license." + i + ".distribution", license.getDistribution());
        }
        result.setProperties(properties);
        this.setArtifactProperties(result, model);
    }

    private org.eclipse.aether.graph.Dependency convert(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<org.eclipse.aether.graph.Exclusion> exclusions = new ArrayList<org.eclipse.aether.graph.Exclusion>(dependency.getExclusions().size());
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        org.eclipse.aether.graph.Dependency result = new org.eclipse.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
        return result;
    }

    private org.eclipse.aether.graph.Exclusion convert(Exclusion exclusion) {
        return new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void setArtifactProperties(ArtifactDescriptorResult result, Model model) {
        String downloadUrl = null;
        DistributionManagement distMngt = model.getDistributionManagement();
        if (distMngt != null) {
            downloadUrl = distMngt.getDownloadUrl();
        }
        if (downloadUrl != null && downloadUrl.length() > 0) {
            Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }
}

