/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

final class ManifestCreator {
    private ManifestCreator() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static Manifest createManifest(MavenProject project) throws ManifestException {
        Dependency verifierDependency;
        Manifest manifest = new Manifest();
        Plugin verifierMavenPlugin = ManifestCreator.findMavenPlugin(project.getBuildPlugins());
        if (verifierMavenPlugin != null) {
            manifest.addConfiguredAttribute(new Manifest.Attribute("Spring-Cloud-Contract-Maven-Plugin-Version", verifierMavenPlugin.getVersion()));
        }
        if (verifierMavenPlugin != null && !verifierMavenPlugin.getDependencies().isEmpty() && (verifierDependency = ManifestCreator.findVerifierDependency(verifierMavenPlugin.getDependencies())) != null) {
            String verifierVersion = verifierDependency.getVersion();
            manifest.addConfiguredAttribute(new Manifest.Attribute("Spring-Cloud-Contract-Verifier-Version", verifierVersion));
        }
        return manifest;
    }

    private static Plugin findMavenPlugin(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!"spring-cloud-contract-maven-plugin".equals(plugin.getArtifactId())) continue;
            return plugin;
        }
        return null;
    }

    private static Dependency findVerifierDependency(List<Dependency> deps) {
        for (Dependency dep : deps) {
            if (!"spring-cloud-contract-verifier".equals(dep.getArtifactId())) continue;
            return dep;
        }
        return null;
    }
}

