/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier.stubrunner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.stubrunner.AetherStubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class AetherStubDownloaderFactory {
    private static final Log log = LogFactory.getLog(AetherStubDownloaderFactory.class);
    private final MavenProject project;
    private final RepositorySystem repoSystem;
    private final Settings settings;

    @Autowired
    public AetherStubDownloaderFactory(RepositorySystem repoSystem, MavenProject project, Settings settings) {
        this.repoSystem = repoSystem;
        this.project = project;
        this.settings = settings;
    }

    public StubDownloaderBuilder build(final RepositorySystemSession repoSession) {
        return new StubDownloaderBuilder(){

            public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
                log.info((Object)"Will download contracts using current build's Maven repository setup");
                return new AetherStubDownloader(AetherStubDownloaderFactory.this.repoSystem, AetherStubDownloaderFactory.this.project.getRemoteProjectRepositories(), repoSession, AetherStubDownloaderFactory.this.settings);
            }

            public Resource resolve(String location, ResourceLoader resourceLoader) {
                return null;
            }
        };
    }
}

