/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.maven.verifier.BaseClassMapping;
import org.springframework.cloud.contract.maven.verifier.ChangeDetector;
import org.springframework.cloud.contract.maven.verifier.LeftOverPrevention;
import org.springframework.cloud.contract.maven.verifier.MavenContractsDownloader;
import org.springframework.cloud.contract.spec.ContractVerifierException;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.TestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.config.TestMode;
import org.springframework.util.StringUtils;

@Mojo(name="generateTests", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class GenerateTestsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="spring.cloud.contract.verifier.contractsDirectory", defaultValue="${project.basedir}/src/test/resources/contracts")
    private File contractsDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/contracts")
    private File generatedTestSourcesDir;
    @Parameter(defaultValue="${project.build.directory}/generated-test-resources/contracts")
    private File generatedTestResourcesDir;
    @Parameter
    private String basePackageForTests;
    @Parameter
    private String baseClassForTests;
    @Parameter(defaultValue="MOCKMVC")
    private TestMode testMode;
    @Parameter(defaultValue="JUNIT5")
    private TestFramework testFramework;
    @Parameter
    private String ruleClassForTests;
    @Parameter
    private String nameSuffixForTests;
    @Parameter
    private String[] imports;
    @Parameter
    private String[] staticImports;
    @Parameter
    private List<String> excludedFiles;
    @Parameter(property="includedFiles")
    private List<String> includedFiles;
    @Parameter(property="spring.cloud.contract.verifier.assert.size", defaultValue="false")
    private boolean assertJsonSize;
    @Parameter
    private List<String> ignoredFiles;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean mavenTestSkip;
    @Parameter(property="contractsRepositoryUrl")
    private String contractsRepositoryUrl;
    @Parameter(property="contractDependency")
    private Dependency contractDependency;
    @Parameter(property="contractsPath")
    private String contractsPath;
    @Parameter(property="contractsMode", defaultValue="CLASSPATH")
    private StubRunnerProperties.StubsMode contractsMode;
    @Parameter(property="packageWithBaseClasses")
    private String packageWithBaseClasses;
    @Parameter(property="baseClassMappings")
    private List<BaseClassMapping> baseClassMappings;
    @Parameter(property="contractsRepositoryUsername")
    private String contractsRepositoryUsername;
    @Parameter(property="contractsRepositoryPassword")
    private String contractsRepositoryPassword;
    @Parameter(property="contractsRepositoryProxyHost")
    private String contractsRepositoryProxyHost;
    @Parameter(property="contractsRepositoryProxyPort")
    private Integer contractsRepositoryProxyPort;
    @Parameter(property="deleteStubsAfterTest", defaultValue="true")
    private boolean deleteStubsAfterTest;
    @Parameter(property="contractsProperties")
    private Map<String, String> contractsProperties = new HashMap<String, String>();
    @Parameter(property="failOnNoContracts", defaultValue="true")
    private boolean failOnNoContracts;
    @Parameter(property="failOnInProgress", defaultValue="true")
    private boolean failOnInProgress = true;
    @Parameter(property="incrementalContractTests", defaultValue="true")
    private boolean incrementalContractTests = true;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.mavenTestSkip) {
            if (this.skip) {
                this.getLog().info((CharSequence)("Skipping Spring Cloud Contract Verifier execution: spring.cloud.contract.verifier.skip=" + this.skip));
            }
            if (this.mavenTestSkip) {
                this.getLog().info((CharSequence)("Skipping Spring Cloud Contract Verifier execution: maven.test.skip=" + this.mavenTestSkip));
            }
            return;
        }
        this.getLog().info((CharSequence)"Generating server tests source code for Spring Cloud Contract Verifier contract verification");
        ContractVerifierConfigProperties config = new ContractVerifierConfigProperties();
        config.setFailOnInProgress(this.failOnInProgress);
        File contractsDirectory = new MavenContractsDownloader(this.project, this.contractDependency, this.contractsPath, this.contractsRepositoryUrl, this.contractsMode, this.getLog(), this.contractsRepositoryUsername, this.contractsRepositoryPassword, this.contractsRepositoryProxyHost, this.contractsRepositoryProxyPort, this.deleteStubsAfterTest, this.contractsProperties, this.failOnNoContracts).downloadAndUnpackContractsIfRequired(config, this.contractsDirectory);
        this.getLog().info((CharSequence)("Directory with contract is present at [" + contractsDirectory + "]"));
        this.throwExceptionWhenFailOnNoContracts(contractsDirectory, this.contractsRepositoryUrl);
        if (this.incrementalContractTests && !ChangeDetector.inputFilesChangeDetected(contractsDirectory, this.mojoExecution, this.session)) {
            this.getLog().info((CharSequence)"Nothing to generate - all classes are up to date");
            return;
        }
        this.setupConfig(config, contractsDirectory);
        this.project.addTestCompileSourceRoot(this.generatedTestSourcesDir.getAbsolutePath());
        Resource resource = new Resource();
        resource.setDirectory(this.generatedTestResourcesDir.getAbsolutePath());
        this.project.addTestResource(resource);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Test Source directory: " + this.generatedTestSourcesDir.getAbsolutePath() + " added."));
            this.getLog().info((CharSequence)("Using [" + config.getBaseClassForTests() + "] as base class for test classes, [" + config.getBasePackageForTests() + "] as base package for tests, [" + config.getPackageWithBaseClasses() + "] as package with base classes, base class mappings " + this.baseClassMappings));
        }
        try {
            LeftOverPrevention leftOverPrevention = new LeftOverPrevention(this.generatedTestSourcesDir, this.mojoExecution, this.session);
            TestGenerator generator = new TestGenerator(config);
            int generatedClasses = generator.generate();
            this.getLog().info((CharSequence)("Generated " + generatedClasses + " test classes."));
            leftOverPrevention.deleteLeftOvers();
        }
        catch (ContractVerifierException e) {
            throw new MojoExecutionException(String.format("Spring Cloud Contract Verifier Plugin exception: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    private void throwExceptionWhenFailOnNoContracts(File file, String contractsRepository) throws MojoExecutionException {
        if (StringUtils.hasText((String)contractsRepository)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Contracts repository is set, will not throw an exception that the contracts are not found");
            }
            return;
        }
        if (this.failOnNoContracts && (!file.exists() || file.listFiles().length == 0)) {
            String path = file.getAbsolutePath();
            throw new MojoExecutionException("Contracts could not be found: [" + path + "]\nPlease make sure that the contracts were defined, or set the [failOnNoContracts] property to [false]");
        }
    }

    private void setupConfig(ContractVerifierConfigProperties config, File contractsDirectory) {
        config.setContractsDslDir(contractsDirectory);
        config.setGeneratedTestSourcesDir(this.generatedTestSourcesDir);
        config.setGeneratedTestResourcesDir(this.generatedTestResourcesDir);
        config.setTestFramework(this.testFramework);
        config.setTestMode(this.testMode);
        config.setBasePackageForTests(this.basePackageForTests);
        config.setBaseClassForTests(this.baseClassForTests);
        config.setRuleClassForTests(this.ruleClassForTests);
        config.setNameSuffixForTests(this.nameSuffixForTests);
        config.setImports(this.imports);
        config.setStaticImports(this.staticImports);
        config.setIgnoredFiles(this.ignoredFiles);
        config.setExcludedFiles(this.excludedFiles);
        config.setIncludedFiles(this.includedFiles);
        config.setAssertJsonSize(Boolean.valueOf(this.assertJsonSize));
        config.setPackageWithBaseClasses(this.packageWithBaseClasses);
        if (this.baseClassMappings != null) {
            config.setBaseClassMappings(this.mappingsToMap());
        }
    }

    public Map<String, String> mappingsToMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.baseClassMappings == null) {
            return map;
        }
        for (BaseClassMapping mapping : this.baseClassMappings) {
            map.put(mapping.getContractPackageRegex(), mapping.getBaseClassFQN());
        }
        return map;
    }

    public List<String> getExcludedFiles() {
        return this.excludedFiles;
    }

    public void setExcludedFiles(List<String> excludedFiles) {
        this.excludedFiles = excludedFiles;
    }

    public List<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void setIgnoredFiles(List<String> ignoredFiles) {
        this.ignoredFiles = ignoredFiles;
    }

    public boolean isAssertJsonSize() {
        return this.assertJsonSize;
    }

    public void setAssertJsonSize(boolean assertJsonSize) {
        this.assertJsonSize = assertJsonSize;
    }
}

