/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.config.TestMode;
import org.springframework.util.Assert;

public class ContractVerifierExtension
implements Serializable {
    private final Property<TestFramework> testFramework;
    private final Property<TestMode> testMode;
    private final Property<String> basePackageForTests;
    private final Property<String> baseClassForTests;
    private final Property<String> nameSuffixForTests;
    private final ListProperty<String> excludedFiles;
    private final ListProperty<String> includedFiles;
    private final ListProperty<String> ignoredFiles;
    private final ListProperty<String> imports;
    private final ListProperty<String> staticImports;
    private final DirectoryProperty contractsDslDir;
    private final DirectoryProperty generatedTestJavaSourcesDir;
    private final DirectoryProperty generatedTestGroovySourcesDir;
    private final DirectoryProperty generatedTestResourcesDir;
    private final DirectoryProperty stubsOutputDir;
    private final Property<String> stubsSuffix;
    private final Property<Boolean> assertJsonSize;
    private final Property<Boolean> failOnNoContracts;
    private final Property<Boolean> failOnInProgress;
    private final ContractRepository contractRepository;
    private final PublishStubsToScm publishStubsToScm;
    private final Dependency contractDependency;
    private final Property<String> contractsPath;
    private final Property<StubRunnerProperties.StubsMode> contractsMode;
    private final Property<String> packageWithBaseClasses;
    private final BaseClassMapping baseClassMappings;
    private final Property<Boolean> excludeBuildFolders;
    private final Property<Boolean> deleteStubsAfterTest;
    private final Property<Boolean> convertToYaml;
    private final MapProperty<String, String> contractsProperties;
    private final Property<String> sourceSet;

    @Inject
    public ContractVerifierExtension(ProjectLayout layout, ObjectFactory objects) {
        this.testFramework = objects.property(TestFramework.class).convention((Object)TestFramework.JUNIT5);
        this.testMode = objects.property(TestMode.class).convention((Object)TestMode.MOCKMVC);
        this.basePackageForTests = objects.property(String.class);
        this.baseClassForTests = objects.property(String.class);
        this.nameSuffixForTests = objects.property(String.class);
        this.excludedFiles = objects.listProperty(String.class).convention(new ArrayList());
        this.includedFiles = objects.listProperty(String.class).convention(new ArrayList());
        this.ignoredFiles = objects.listProperty(String.class).convention(new ArrayList());
        this.imports = objects.listProperty(String.class).convention(new ArrayList());
        this.staticImports = objects.listProperty(String.class).convention(new ArrayList());
        this.contractsDslDir = objects.directoryProperty().convention(layout.getProjectDirectory().dir("src/contractTest/resources/contracts"));
        this.generatedTestJavaSourcesDir = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated-test-sources/contractTest/java"));
        this.generatedTestGroovySourcesDir = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated-test-sources/contractTest/groovy"));
        this.generatedTestResourcesDir = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated-test-resources/contractTest"));
        this.stubsOutputDir = objects.directoryProperty().convention(layout.getBuildDirectory().dir("stubs"));
        this.stubsSuffix = objects.property(String.class).convention((Object)"stubs");
        this.assertJsonSize = objects.property(Boolean.class).convention((Object)false);
        this.failOnNoContracts = objects.property(Boolean.class).convention((Object)true);
        this.failOnInProgress = objects.property(Boolean.class).convention((Object)true);
        this.contractRepository = (ContractRepository)objects.newInstance(ContractRepository.class, new Object[0]);
        this.publishStubsToScm = (PublishStubsToScm)objects.newInstance(PublishStubsToScm.class, new Object[0]);
        this.contractDependency = (Dependency)objects.newInstance(Dependency.class, new Object[0]);
        this.contractsPath = objects.property(String.class);
        this.contractsMode = objects.property(StubRunnerProperties.StubsMode.class).convention((Object)StubRunnerProperties.StubsMode.CLASSPATH);
        this.packageWithBaseClasses = objects.property(String.class);
        this.baseClassMappings = (BaseClassMapping)objects.newInstance(BaseClassMapping.class, new Object[0]);
        this.excludeBuildFolders = objects.property(Boolean.class).convention((Object)false);
        this.deleteStubsAfterTest = objects.property(Boolean.class).convention((Object)true);
        this.convertToYaml = objects.property(Boolean.class).convention((Object)false);
        this.contractsProperties = objects.mapProperty(String.class, String.class).convention(new HashMap());
        this.sourceSet = objects.property(String.class);
    }

    public Property<TestFramework> getTestFramework() {
        return this.testFramework;
    }

    public void setTestFramework(TestFramework testFramework) {
        this.testFramework.set((Object)testFramework);
    }

    public void setTestFramework(String testFramework) {
        this.testFramework.set((Object)TestFramework.valueOf((String)testFramework.toUpperCase(Locale.ROOT)));
    }

    public Property<TestMode> getTestMode() {
        return this.testMode;
    }

    public void setTestMode(TestMode testMode) {
        this.testMode.set((Object)testMode);
    }

    public void setTestMode(String testMode) {
        this.testMode.set((Object)TestMode.valueOf((String)testMode.toUpperCase(Locale.ROOT)));
    }

    public Property<String> getBasePackageForTests() {
        return this.basePackageForTests;
    }

    public void setBasePackageForTests(String basePackageForTests) {
        this.basePackageForTests.set((Object)basePackageForTests);
    }

    public Property<String> getBaseClassForTests() {
        return this.baseClassForTests;
    }

    public void setBaseClassForTests(String baseClassForTests) {
        this.baseClassForTests.set((Object)baseClassForTests);
    }

    public Property<String> getNameSuffixForTests() {
        return this.nameSuffixForTests;
    }

    public void setNameSuffixForTests(String nameSuffixForTests) {
        this.nameSuffixForTests.set((Object)nameSuffixForTests);
    }

    public ListProperty<String> getExcludedFiles() {
        return this.excludedFiles;
    }

    public void setExcludedFiles(List<String> excludedFiles) {
        this.excludedFiles.set(excludedFiles);
    }

    public ListProperty<String> getIncludedFiles() {
        return this.includedFiles;
    }

    public void setIncludedFiles(List<String> includedFiles) {
        this.includedFiles.set(includedFiles);
    }

    public ListProperty<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void setIgnoredFiles(List<String> ignoredFiles) {
        this.ignoredFiles.set(ignoredFiles);
    }

    public ListProperty<String> getImports() {
        return this.imports;
    }

    public void setImports(String[] imports) {
        this.imports.set(new ArrayList<String>(Arrays.asList(imports)));
    }

    public void setInputs(List<String> imports) {
        this.imports.set(imports);
    }

    public ListProperty<String> getStaticImports() {
        return this.staticImports;
    }

    public void setStaticImports(String[] staticImports) {
        this.staticImports.set(new ArrayList<String>(Arrays.asList(staticImports)));
    }

    public void setStaticImports(List<String> staticImports) {
        this.staticImports.set(staticImports);
    }

    public DirectoryProperty getContractsDslDir() {
        return this.contractsDslDir;
    }

    public void setContractsDslDir(File contractsDslDir) {
        this.contractsDslDir.set(contractsDslDir);
    }

    public DirectoryProperty getGeneratedTestJavaSourcesDir() {
        return this.generatedTestJavaSourcesDir;
    }

    public void setGeneratedTestJavaSourcesDir(File generatedTestJavaSourcesDir) {
        this.generatedTestJavaSourcesDir.set(generatedTestJavaSourcesDir);
    }

    public DirectoryProperty getGeneratedTestGroovySourcesDir() {
        return this.generatedTestGroovySourcesDir;
    }

    public void setGeneratedTestGroovySourcesDir(File generatedTestGroovySourcesDir) {
        this.generatedTestGroovySourcesDir.set(generatedTestGroovySourcesDir);
    }

    public DirectoryProperty getGeneratedTestResourcesDir() {
        return this.generatedTestResourcesDir;
    }

    public void setGeneratedTestResourcesDir(File generatedTestResourcesDir) {
        this.generatedTestResourcesDir.set(generatedTestResourcesDir);
    }

    public DirectoryProperty getStubsOutputDir() {
        return this.stubsOutputDir;
    }

    public void setStubsOutputDir(File stubsOutputDir) {
        this.stubsOutputDir.set(stubsOutputDir);
    }

    public Property<String> getStubsSuffix() {
        return this.stubsSuffix;
    }

    public void setStubsSuffix(String stubsSuffix) {
        this.stubsSuffix.set((Object)stubsSuffix);
    }

    public Property<Boolean> getAssertJsonSize() {
        return this.assertJsonSize;
    }

    public void setAssertJsonSize(boolean assertJsonSize) {
        this.assertJsonSize.set((Object)assertJsonSize);
    }

    public Property<Boolean> getFailOnNoContracts() {
        return this.failOnNoContracts;
    }

    public void setFailOnNoContracts(boolean failOnNoContracts) {
        this.failOnNoContracts.set((Object)failOnNoContracts);
    }

    public Property<Boolean> getFailOnInProgress() {
        return this.failOnInProgress;
    }

    public void setFailOnInProgress(boolean failOnInProgress) {
        this.failOnInProgress.set((Object)failOnInProgress);
    }

    public ContractRepository getContractRepository() {
        return this.contractRepository;
    }

    public void contractRepository(Action<ContractRepository> action) {
        action.execute((Object)this.contractRepository);
    }

    public PublishStubsToScm getPublishStubsToScm() {
        return this.publishStubsToScm;
    }

    public void publishStubsToScm(Action<PublishStubsToScm> action) {
        action.execute((Object)this.publishStubsToScm);
    }

    public Dependency getContractDependency() {
        return this.contractDependency;
    }

    public void contractDependency(Action<Dependency> action) {
        action.execute((Object)this.contractDependency);
    }

    public Property<String> getContractsPath() {
        return this.contractsPath;
    }

    public void setContractsPath(String contractsPath) {
        this.contractsPath.set((Object)contractsPath);
    }

    public Property<StubRunnerProperties.StubsMode> getContractsMode() {
        return this.contractsMode;
    }

    public void setContractsMode(StubRunnerProperties.StubsMode contractsMode) {
        this.contractsMode.set((Object)contractsMode);
    }

    public void setContractsMode(String contractsMode) {
        this.contractsMode.set((Object)StubRunnerProperties.StubsMode.valueOf((String)contractsMode.toUpperCase(Locale.ROOT)));
    }

    public Property<String> getPackageWithBaseClasses() {
        return this.packageWithBaseClasses;
    }

    public void setPackageWithBaseClasses(String packageWithBaseClasses) {
        this.packageWithBaseClasses.set((Object)packageWithBaseClasses);
    }

    public BaseClassMapping getBaseClassMappings() {
        return this.baseClassMappings;
    }

    public void setBaseClassMappings(Map<String, String> baseClassMappings) {
        this.baseClassMappings.getBaseClassMappings().set(baseClassMappings);
    }

    public void baseClassMappings(Action<BaseClassMapping> action) {
        action.execute((Object)this.baseClassMappings);
    }

    public Property<Boolean> getExcludeBuildFolders() {
        return this.excludeBuildFolders;
    }

    public void setExcludeBuildFolders(boolean excludeBuildFolders) {
        this.excludeBuildFolders.set((Object)excludeBuildFolders);
    }

    public Property<Boolean> getDeleteStubsAfterTest() {
        return this.deleteStubsAfterTest;
    }

    public void setDeleteStubsAfterTest(boolean deleteStubsAfterTest) {
        this.deleteStubsAfterTest.set((Object)deleteStubsAfterTest);
    }

    public Property<Boolean> getConvertToYaml() {
        return this.convertToYaml;
    }

    public void setConvertToYaml(boolean convertToYaml) {
        this.convertToYaml.set((Object)convertToYaml);
    }

    public MapProperty<String, String> getContractsProperties() {
        return this.contractsProperties;
    }

    public void setContractsProperties(Map<String, String> contractsProperties) {
        this.contractsProperties.set(contractsProperties);
    }

    public Property<String> getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(String sourceSet) {
        this.sourceSet.set((Object)sourceSet);
    }

    public static class ContractRepository
    implements Serializable {
        private final Property<String> repositoryUrl;
        private final Property<String> username;
        private final Property<String> password;
        private final Property<Integer> proxyPort;
        private final Property<String> proxyHost;

        @Inject
        public ContractRepository(ObjectFactory objects) {
            this.repositoryUrl = objects.property(String.class);
            this.username = objects.property(String.class);
            this.password = objects.property(String.class);
            this.proxyHost = objects.property(String.class);
            this.proxyPort = objects.property(Integer.class);
        }

        public Property<String> getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl.set((Object)repositoryUrl);
        }

        public Property<String> getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username.set((Object)username);
        }

        public Property<String> getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password.set((Object)password);
        }

        public Property<String> getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost.set((Object)proxyHost);
        }

        public Property<Integer> getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            Assert.state((0 < proxyPort && proxyPort <= 65536 ? 1 : 0) != 0, (String)"Proxy port should be between 1 and 65536");
            this.proxyPort.set((Object)proxyPort);
        }

        public String toString() {
            return "ContractRepository{repositoryUrl=" + (String)this.repositoryUrl.getOrNull() + ", username=" + (String)this.username.getOrNull() + ", password=" + (String)this.password.getOrNull() + ", proxyPort=" + this.proxyPort.getOrNull() + ", proxyHost=" + (String)this.proxyHost.getOrNull() + "}";
        }
    }

    public static class PublishStubsToScm
    implements Serializable {
        private final Dependency contractDependency;
        private final ContractRepository contractRepository;

        @Inject
        public PublishStubsToScm(ObjectFactory objects) {
            this.contractDependency = (Dependency)objects.newInstance(Dependency.class, new Object[0]);
            this.contractRepository = (ContractRepository)objects.newInstance(ContractRepository.class, new Object[0]);
        }

        public Dependency getContractDependency() {
            return this.contractDependency;
        }

        public void contractDependency(Action<Dependency> action) {
            action.execute((Object)this.contractDependency);
        }

        public ContractRepository getContractRepository() {
            return this.contractRepository;
        }

        public void contractRepository(Action<ContractRepository> action) {
            action.execute((Object)this.contractRepository);
        }

        public String toString() {
            return "PublishStubsToScm{contractDependency=" + this.contractDependency + ", contractRepository=" + this.contractRepository + "}";
        }
    }

    public static class Dependency
    implements Serializable {
        private final Property<String> groupId;
        private final Property<String> artifactId;
        private final Property<String> version;
        private final Property<String> classifier;
        private final Property<String> stringNotation;

        @Inject
        public Dependency(ObjectFactory objects) {
            this.groupId = objects.property(String.class);
            this.artifactId = objects.property(String.class);
            this.version = objects.property(String.class);
            this.classifier = objects.property(String.class);
            this.stringNotation = objects.property(String.class);
        }

        public Property<String> getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId.set((Object)groupId);
        }

        public Property<String> getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId.set((Object)artifactId);
        }

        public Property<String> getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version.set((Object)version);
        }

        public Property<String> getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier.set((Object)classifier);
        }

        public Property<String> getStringNotation() {
            return this.stringNotation;
        }

        public void setStringNotation(String stringNotation) {
            this.stringNotation.set((Object)stringNotation);
        }

        public String toString() {
            return "Dependency{groupId=" + (String)this.groupId.getOrNull() + ", artifactId=" + (String)this.artifactId.getOrNull() + ", classifier=" + (String)this.classifier.getOrNull() + ", version=" + (String)this.version.getOrNull() + ", stringNotation=" + (String)this.stringNotation.getOrNull() + "}";
        }
    }

    public static class BaseClassMapping
    implements Serializable {
        private final MapProperty<String, String> baseClassMappings;

        @Inject
        public BaseClassMapping(ObjectFactory objects) {
            this.baseClassMappings = objects.mapProperty(String.class, String.class).convention(new HashMap());
        }

        public MapProperty<String, String> getBaseClassMappings() {
            return this.baseClassMappings;
        }

        public void baseClassMapping(String packageRegex, String fqnBaseClass) {
            this.baseClassMappings.put((Object)packageRegex, (Object)fqnBaseClass);
        }

        public void baseClassMapping(Map<String, String> mapping) {
            this.baseClassMappings.putAll(mapping);
        }
    }
}

