/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.springframework.cloud.contract.verifier.converter.RecursiveFilesConverter;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.ContractsCopyTask;

public class GenerateClientStubsFromDslTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "generateClientStubs";
    private static final String DEFAULT_MAPPINGS_FOLDER = "mappings";
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public GenerateClientStubsFromDslTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void generate() {
        File output = ((Directory)this.config.getStubsOutputDir().get()).getAsFile();
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{output}, new String[]{"Stubs output dir [", ""})));
        this.getLogger().info("Spring Cloud Contract Verifier Plugin: Invoking DSL to client stubs conversion");
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Directory)this.config.getContractsDslDir().get()).getAsFile(), output}, new String[]{"Contracts dir is [", "] output stubs dir is [", "]"})));
        List excludedFiles = (List)ScriptBytecodeAdapter.castToType((Object)this.config.getExcludedFiles().get(), List.class);
        RecursiveFilesConverter converter = new RecursiveFilesConverter(output, ((Directory)this.config.getContractsDslDir().get()).getAsFile(), excludedFiles, ".*", DefaultTypeTransformation.booleanUnbox((Object)this.config.getExcludeBuildFolders().get()));
        converter.processFiles();
    }

    public static Config fromExtension(ContractVerifierExtension extension, TaskProvider<ContractsCopyTask> copyContracts, String root, Project project) {
        Config config = new Config();
        public final class _fromExtension_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromExtension_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ContractsCopyTask)((Object)it)).getConfig().getCopiedContractsFolder();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromExtension_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider = copyContracts.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _fromExtension_closure1(GenerateClientStubsFromDslTask.class, GenerateClientStubsFromDslTask.class)), Transformer.class));
        config.setContractsDslDir((Provider<Directory>)provider);
        ListProperty<String> listProperty = extension.getExcludedFiles();
        config.setExcludedFiles(listProperty);
        Property<Boolean> property = extension.getExcludeBuildFolders();
        config.setExcludeBuildFolders((Provider<Boolean>)property);
        DirectoryProperty directoryProperty = GenerateClientStubsFromDslTask.createTaskOutput(root, extension.getStubsOutputDir(), project);
        config.setStubsOutputDir((Provider<Directory>)directoryProperty);
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static DirectoryProperty createTaskOutput(String root, DirectoryProperty stubsOutputDir, Project project) {
        void var2_2;
        Reference root2 = new Reference((Object)root);
        Reference project2 = new Reference((Object)var2_2);
        public final class _createTaskOutput_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference root;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createTaskOutput_closure2(Object _outerInstance, Object _thisObject, Reference root, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.root = reference2 = root;
                this.project = reference = project;
            }

            public Object doCall(Object it) {
                Directory dir = (Directory)ScriptBytecodeAdapter.castToType((Object)it, Directory.class);
                File output = new File(dir.getAsFile(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.root.get(), DEFAULT_MAPPINGS_FOLDER}, new String[]{"", "/", ""})));
                DirectoryProperty property = ((Project)this.project.get()).getObjects().directoryProperty();
                property.set(output);
                return property;
            }

            @Generated
            public String getRoot() {
                return ShortTypeHandling.castToString((Object)this.root.get());
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTaskOutput_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider = stubsOutputDir.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _createTaskOutput_closure2(GenerateClientStubsFromDslTask.class, GenerateClientStubsFromDslTask.class, root2, project2)), Transformer.class));
        DirectoryProperty property = ((Project)project2.get()).getObjects().directoryProperty();
        property.set(provider);
        return property;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GenerateClientStubsFromDslTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GenerateClientStubsFromDslTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GenerateClientStubsFromDslTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GenerateClientStubsFromDslTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @InputDirectory
        private Provider<Directory> contractsDslDir;
        @Input
        private ListProperty<String> excludedFiles;
        @Input
        private Provider<Boolean> excludeBuildFolders;
        @OutputDirectory
        private Provider<Directory> stubsOutputDir;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public Config() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, GenerateClientStubsFromDslTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, GenerateClientStubsFromDslTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateClientStubsFromDslTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateClientStubsFromDslTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, GenerateClientStubsFromDslTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, GenerateClientStubsFromDslTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Provider<Directory> getContractsDslDir() {
            return this.contractsDslDir;
        }

        @Generated
        public void setContractsDslDir(Provider<Directory> provider) {
            this.contractsDslDir = provider;
        }

        @Generated
        public ListProperty<String> getExcludedFiles() {
            return this.excludedFiles;
        }

        @Generated
        public void setExcludedFiles(ListProperty<String> listProperty) {
            this.excludedFiles = listProperty;
        }

        @Generated
        public Provider<Boolean> getExcludeBuildFolders() {
            return this.excludeBuildFolders;
        }

        @Generated
        public void setExcludeBuildFolders(Provider<Boolean> provider) {
            this.excludeBuildFolders = provider;
        }

        @Generated
        public Provider<Directory> getStubsOutputDir() {
            return this.stubsOutputDir;
        }

        @Generated
        public void setStubsOutputDir(Provider<Directory> provider) {
            this.stubsOutputDir = provider;
        }
    }
}

