/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.wiremock.WireMockMetaData;
import org.springframework.cloud.contract.verifier.wiremock.WireMockStubPostProcessor;

class DefaultWireMockStubPostProcessor
implements WireMockStubPostProcessor {
    private final ObjectMapper objectMapper = new ObjectMapper();

    DefaultWireMockStubPostProcessor() {
    }

    @Override
    public StubMapping postProcess(StubMapping stubMapping, Contract contract) {
        WireMockMetaData wireMockMetaData = WireMockMetaData.fromMetadata(contract.getMetadata());
        StubMapping stubMappingFromMetadata = this.stubMappingFromMetadata(wireMockMetaData.getStubMapping());
        stubMapping.setResponse(this.mergedResponse(stubMapping, stubMappingFromMetadata));
        if (stubMappingFromMetadata.getPostServeActions() != null) {
            this.setPostServeActions(stubMapping, stubMappingFromMetadata);
        }
        if (stubMappingFromMetadata.getMetadata() != null) {
            this.setMetadata(stubMapping, stubMappingFromMetadata);
        }
        return stubMapping;
    }

    public void setPostServeActions(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        Map postServeActions = stubMapping.getPostServeActions();
        postServeActions = postServeActions != null ? postServeActions : new HashMap();
        postServeActions.putAll(stubMappingFromMetadata.getPostServeActions());
        stubMapping.setPostServeActions(postServeActions);
    }

    public void setMetadata(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        Metadata metadata = stubMapping.getMetadata();
        metadata = metadata != null ? metadata : new Metadata();
        metadata.putAll((Map)stubMappingFromMetadata.getMetadata());
        stubMapping.setMetadata(metadata);
    }

    public ResponseDefinition mergedResponse(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        ResponseDefinition responseDefinition = new ResponseDefinition(stubMapping.getResponse().getStatus(), stubMapping.getResponse().getStatusMessage(), stubMapping.getResponse().getBody(), stubMapping.getResponse().getJsonBody(), stubMapping.getResponse().getBase64Body(), stubMapping.getResponse().getBodyFileName(), stubMapping.getResponse().getHeaders(), stubMapping.getResponse().getAdditionalProxyRequestHeaders(), this.fixedDelayMilliseconds(stubMapping, stubMappingFromMetadata), this.delayDistribution(stubMapping, stubMappingFromMetadata), this.chunkedDribbleDelay(stubMapping, stubMappingFromMetadata), this.proxyBaseUrl(stubMapping, stubMappingFromMetadata), this.fault(stubMapping, stubMappingFromMetadata), this.transformers(stubMapping, stubMappingFromMetadata), this.transformerParameters(stubMapping, stubMappingFromMetadata), this.wasConfigured(stubMapping, stubMappingFromMetadata));
        return responseDefinition;
    }

    public Boolean wasConfigured(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().isFromConfiguredStub() != null ? stubMappingFromMetadata.getResponse().isFromConfiguredStub() : stubMapping.getResponse().isFromConfiguredStub();
    }

    public Parameters transformerParameters(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getTransformerParameters() != null ? stubMappingFromMetadata.getResponse().getTransformerParameters() : stubMapping.getResponse().getTransformerParameters();
    }

    public List<String> transformers(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getTransformers() != null ? stubMappingFromMetadata.getResponse().getTransformers() : stubMapping.getResponse().getTransformers();
    }

    public Fault fault(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getFault() != null ? stubMappingFromMetadata.getResponse().getFault() : stubMapping.getResponse().getFault();
    }

    public String proxyBaseUrl(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getProxyBaseUrl() != null ? stubMappingFromMetadata.getResponse().getProxyBaseUrl() : stubMapping.getResponse().getProxyBaseUrl();
    }

    public ChunkedDribbleDelay chunkedDribbleDelay(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getChunkedDribbleDelay() != null ? stubMappingFromMetadata.getResponse().getChunkedDribbleDelay() : stubMapping.getResponse().getChunkedDribbleDelay();
    }

    public DelayDistribution delayDistribution(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getDelayDistribution() != null ? stubMappingFromMetadata.getResponse().getDelayDistribution() : stubMapping.getResponse().getDelayDistribution();
    }

    public Integer fixedDelayMilliseconds(StubMapping stubMapping, StubMapping stubMappingFromMetadata) {
        return stubMappingFromMetadata.getResponse().getFixedDelayMilliseconds() != null ? stubMappingFromMetadata.getResponse().getFixedDelayMilliseconds() : stubMapping.getResponse().getFixedDelayMilliseconds();
    }

    private StubMapping stubMappingFromMetadata(Object wiremock) {
        if (wiremock instanceof String) {
            return StubMapping.buildFrom((String)((String)wiremock));
        }
        if (wiremock instanceof StubMapping) {
            return (StubMapping)wiremock;
        }
        if (wiremock instanceof Map) {
            try {
                return StubMapping.buildFrom((String)this.objectMapper.writeValueAsString(wiremock));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Failed to build StubMapping for map [" + wiremock + "]", e);
            }
        }
        throw new UnsupportedOperationException("Unsupported type for wiremock metadata extension");
    }

    @Override
    public boolean isApplicable(Contract contract) {
        boolean contains = contract.getMetadata().containsKey("wiremock");
        if (!contains) {
            return false;
        }
        Object stubMapping = WireMockMetaData.fromMetadata(contract.getMetadata()).getStubMapping();
        return WireMockMetaData.APPLICABLE_CLASSES.stream().anyMatch(aClass -> aClass.isAssignableFrom(stubMapping.getClass()));
    }
}

