/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public interface PropertySourceLocator {
    public PropertySource<?> locate(Environment var1);

    default public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return PropertySourceLocator.locateCollection(this, environment);
    }

    public static Collection<PropertySource<?>> locateCollection(PropertySourceLocator locator, Environment environment) {
        PropertySource<?> propertySource = locator.locate(environment);
        if (propertySource == null) {
            return Collections.emptyList();
        }
        if (propertySource instanceof CompositePropertySource) {
            Collection sources = ((CompositePropertySource)propertySource).getPropertySources();
            ArrayList filteredSources = new ArrayList();
            for (PropertySource p : sources) {
                if (p == null) continue;
                filteredSources.add(p);
            }
            return filteredSources;
        }
        return List.of(propertySource);
    }
}

