/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.support;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.ReregistrationPredicate;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.serviceregistry.ActuatorHealthApplicationStatusProvider;
import org.springframework.cloud.consul.serviceregistry.ApplicationStatusProvider;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnConsulEnabled
@ConditionalOnProperty(value={"spring.cloud.consul.discovery.heartbeat.enabled"})
@ConditionalOnDiscoveryEnabled
@AutoConfigureBefore(value={ConsulServiceRegistryAutoConfiguration.class})
@AutoConfigureAfter(value={ConsulDiscoveryClientConfiguration.class})
public class ConsulHeartbeatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HeartbeatProperties heartbeatProperties() {
        return new HeartbeatProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public TtlScheduler ttlScheduler(HeartbeatProperties heartbeatProperties, ConsulDiscoveryProperties discoveryProperties, ConsulClient consulClient, ReregistrationPredicate reRegistrationPredicate, ObjectProvider<ApplicationStatusProvider> applicationStatusProvider) {
        return new TtlScheduler(heartbeatProperties, discoveryProperties, consulClient, reRegistrationPredicate, applicationStatusProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReregistrationPredicate reRegistrationPredicate() {
        return ReregistrationPredicate.DEFAULT;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthEndpoint.class})
    @ConditionalOnProperty(value={"spring.cloud.consul.discovery.heartbeat.use-actuator-health"}, havingValue="true", matchIfMissing=true)
    static class ActuatorBasedApplicationStatusProviderConfig {
        ActuatorBasedApplicationStatusProviderConfig() {
        }

        @Bean
        @ConditionalOnBean(value={HealthEndpoint.class})
        @ConditionalOnMissingBean
        public ApplicationStatusProvider actuatorHealthStatusProvider(HealthEndpoint healthEndpoint, HeartbeatProperties heartbeatProperties) {
            return new ActuatorHealthApplicationStatusProvider(healthEndpoint, heartbeatProperties);
        }
    }
}

