/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulCatalogWatch;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnConsulEnabled
@ConditionalOnProperty(value={"spring.cloud.consul.discovery.catalog-services-watch.enabled"}, matchIfMissing=true)
@ConditionalOnDiscoveryEnabled
@AutoConfigureAfter(value={ConsulDiscoveryClientConfiguration.class})
@ConditionalOnBean(value={ConsulDiscoveryProperties.class})
public class ConsulCatalogWatchAutoConfiguration {
    public static final String CATALOG_WATCH_TASK_SCHEDULER_NAME = "catalogWatchTaskScheduler";

    @Bean
    @ConditionalOnMissingBean
    public ConsulCatalogWatch consulCatalogWatch(ConsulDiscoveryProperties discoveryProperties, ConsulClient consulClient, @Qualifier(value="catalogWatchTaskScheduler") TaskScheduler taskScheduler) {
        return new ConsulCatalogWatch(discoveryProperties, consulClient, taskScheduler);
    }

    @Bean(name={"catalogWatchTaskScheduler"})
    public TaskScheduler catalogWatchTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }
}

