/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;
import org.springframework.util.StringUtils;

public class ConsulDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(ConsulDiscoveryClient.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;

    public ConsulDiscoveryClient(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public String description() {
        return "Spring Cloud Consul Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.getInstances(serviceId, QueryParams.DEFAULT);
    }

    public List<ServiceInstance> getInstances(String serviceId, QueryParams queryParams) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        this.addInstancesToList(instances, serviceId, queryParams);
        return instances;
    }

    private void addInstancesToList(List<ServiceInstance> instances, String serviceId, QueryParams queryParams) {
        String aclToken = this.properties.getAclToken();
        Response services = StringUtils.hasText((String)aclToken) ? this.client.getHealthServices(serviceId, this.properties.getDefaultQueryTag(), this.properties.isQueryPassing(), queryParams, aclToken) : this.client.getHealthServices(serviceId, this.properties.getDefaultQueryTag(), this.properties.isQueryPassing(), queryParams);
        for (HealthService service : (List)services.getValue()) {
            String host = ConsulServerUtils.findHost(service);
            Map<String, String> metadata = ConsulServerUtils.getMetadata(service);
            boolean secure = false;
            if (metadata.containsKey("secure")) {
                secure = Boolean.parseBoolean(metadata.get("secure"));
            }
            instances.add((ServiceInstance)new DefaultServiceInstance(service.getService().getId(), serviceId, host, service.getService().getPort().intValue(), secure, metadata));
        }
    }

    public List<ServiceInstance> getAllInstances() {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Response services = this.client.getCatalogServices(QueryParams.DEFAULT);
        for (String serviceId : ((Map)services.getValue()).keySet()) {
            this.addInstancesToList(instances, serviceId, QueryParams.DEFAULT);
        }
        return instances;
    }

    public List<String> getServices() {
        String aclToken = this.properties.getAclToken();
        if (StringUtils.hasText((String)aclToken)) {
            return new ArrayList<String>(((Map)this.client.getCatalogServices(QueryParams.DEFAULT, aclToken).getValue()).keySet());
        }
        return new ArrayList<String>(((Map)this.client.getCatalogServices(QueryParams.DEFAULT).getValue()).keySet());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }

    @Deprecated
    public static interface LocalResolver {
        public String getInstanceId();

        public Integer getPort();
    }
}

