/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.model.HealthService;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServer;

public class ConsulServerList
extends AbstractServerList<ConsulServer> {
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;
    private String serviceId;

    public ConsulServerList(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.serviceId = clientConfig.getClientName();
    }

    public List<ConsulServer> getInitialListOfServers() {
        return this.getServers();
    }

    public List<ConsulServer> getUpdatedListOfServers() {
        return this.getServers();
    }

    private List<ConsulServer> getServers() {
        if (this.client == null) {
            return Collections.emptyList();
        }
        String tag = this.getTag();
        Response response = this.client.getHealthServices(this.serviceId, tag, this.properties.isQueryPassing(), QueryParams.DEFAULT);
        if (response.getValue() == null || ((List)response.getValue()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConsulServer> servers = new ArrayList<ConsulServer>();
        for (HealthService service : (List)response.getValue()) {
            servers.add(new ConsulServer(service));
        }
        return servers;
    }

    private String getTag() {
        return this.properties.getQueryTagForService(this.serviceId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ConsulServerList{");
        sb.append("serviceId='").append(this.serviceId).append('\'');
        sb.append(", tag=").append(this.getTag());
        sb.append('}');
        return sb.toString();
    }
}

