/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;

public class ConsulCatalogWatch
implements ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(ConsulCatalogWatch.class);
    private final ConsulDiscoveryProperties properties;
    private final ConsulClient consul;
    private final AtomicReference<BigInteger> catalogServicesIndex = new AtomicReference();
    private ApplicationEventPublisher publisher;

    public ConsulCatalogWatch(ConsulDiscoveryProperties properties, ConsulClient consul) {
        this.properties = properties;
        this.consul = consul;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedDelayString="${spring.cloud.consul.discovery.catalogServicesWatchDelay:30000}")
    public void catalogServicesWatch() {
        try {
            Response response;
            Long consulIndex;
            long index = -1L;
            if (this.catalogServicesIndex.get() != null) {
                index = this.catalogServicesIndex.get().longValue();
            }
            if ((consulIndex = (response = this.consul.getCatalogServices(new QueryParams((long)this.properties.getCatalogServicesWatchTimeout(), index))).getConsulIndex()) != null) {
                this.catalogServicesIndex.set(BigInteger.valueOf(consulIndex));
            }
            log.trace("Received services update from consul: {}, index: {}", response.getValue(), (Object)consulIndex);
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)consulIndex));
        }
        catch (Exception e) {
            log.error("Error watching Consul CatalogServices", (Throwable)e);
        }
    }
}

