/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.scheduling.annotation.Scheduled;

public class TtlScheduler {
    private static final Logger log = LoggerFactory.getLogger(TtlScheduler.class);
    public static final DateTime EXPIRED_DATE = new DateTime(0L);
    private final Map<String, DateTime> serviceHeartbeats = new ConcurrentHashMap<String, DateTime>();
    private HeartbeatProperties configuration;
    private ConsulClient client;

    public TtlScheduler(HeartbeatProperties configuration, ConsulClient client) {
        this.configuration = configuration;
        this.client = client;
    }

    public void add(NewService service) {
        this.serviceHeartbeats.put(service.getId(), EXPIRED_DATE);
    }

    public void remove(String serviceId) {
        this.serviceHeartbeats.remove(serviceId);
    }

    @Scheduled(initialDelay=0L, fixedRateString="${spring.cloud.consul.discovery.heartbeat.fixedRate:15000}")
    private void heartbeatServices() {
        for (String serviceId : this.serviceHeartbeats.keySet()) {
            DateTime latestHeartbeatDoneForService = this.serviceHeartbeats.get(serviceId);
            if (!latestHeartbeatDoneForService.plus((ReadablePeriod)this.configuration.getHeartbeatInterval()).isBefore((ReadableInstant)DateTime.now())) continue;
            String checkId = serviceId;
            if (!checkId.startsWith("service:")) {
                checkId = "service:" + checkId;
            }
            this.client.agentCheckPass(checkId);
            log.debug("Sending consul heartbeat for: " + serviceId);
            this.serviceHeartbeats.put(serviceId, DateTime.now());
        }
    }
}

