/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.bootstraptests;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.consul.bootstraptests.ConsulBootstrapApplication;
import org.springframework.cloud.consul.bootstraptests.SampleProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableAutoConfiguration
@RestController
@EnableConfigurationProperties
@EnableFeignClients
public class ConsulBootstrapApplication {
    @Autowired
    private LoadBalancerClient loadBalancer;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private Environment env;
    @Autowired
    private SampleClient sampleClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private Registration registration;
    @Value(value="${spring.application.name:testConsulApp}")
    private String appName;

    public static void main(String[] args) {
        SpringApplication.run(ConsulBootstrapApplication.class, (String[])args);
    }

    @GetMapping(value={"/me"})
    public ServiceInstance me() {
        return this.registration;
    }

    @GetMapping(value={"/"})
    public ServiceInstance lb() {
        return this.loadBalancer.choose(this.appName);
    }

    @GetMapping(value={"/rest"})
    public String rest() {
        return (String)this.restTemplate.getForObject("http://" + this.appName + "/me", String.class, new Object[0]);
    }

    @GetMapping(value={"/choose"})
    public String choose() {
        return this.loadBalancer.choose(this.appName).getUri().toString();
    }

    @GetMapping(value={"/myenv"})
    public String env(@RequestParam(value="prop") String prop) {
        return this.env.getProperty(prop, "Not Found");
    }

    @GetMapping(value={"/prop"})
    public String prop() {
        return this.sampleProperties().getProp();
    }

    @GetMapping(value={"/instances"})
    public List<ServiceInstance> instances() {
        return this.discoveryClient.getInstances(this.appName);
    }

    @GetMapping(value={"/feign"})
    public String feign() {
        return this.sampleClient.choose();
    }

    @Bean
    public SampleProperties sampleProperties() {
        return new SampleProperties();
    }

    @Bean
    @LoadBalanced
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}

