/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AwsIamAuthentication;
import org.springframework.vault.authentication.AwsIamAuthenticationOptions;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.web.client.RestOperations;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class AwsIamClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public AwsIamClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.AWS_IAM);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        this.assertClassPresent("software.amazon.awssdk.auth.credentials.AwsCredentials", this.missingClassForAuthMethod("AwsCredentials", "aws-core", VaultEnvironmentProperties.AuthenticationMethod.AWS_IAM));
        VaultEnvironmentProperties.AwsIamProperties awsIam = vaultProperties.getAwsIam();
        AwsCredentialsProvider credentialsProvider = AwsCredentialProvider.getAwsCredentialsProvider();
        AwsIamAuthenticationOptions.AwsIamAuthenticationOptionsBuilder builder = AwsIamAuthenticationOptions.builder();
        if (StringUtils.hasText((String)awsIam.getRole())) {
            builder.role(awsIam.getRole());
        }
        if (StringUtils.hasText((String)awsIam.getServerName())) {
            builder.serverName(awsIam.getServerName());
        }
        if (awsIam.getEndpointUri() != null) {
            builder.endpointUri(awsIam.getEndpointUri());
        }
        builder.path(awsIam.getAwsPath()).credentialsProvider(credentialsProvider);
        AwsIamAuthenticationOptions options = builder.credentialsProvider(credentialsProvider).build();
        return new AwsIamAuthentication(options, vaultRestOperations);
    }

    private static final class AwsCredentialProvider {
        private AwsCredentialProvider() {
        }

        private static AwsCredentialsProvider getAwsCredentialsProvider() {
            final DefaultCredentialsProvider backingCredentialsProvider = DefaultCredentialsProvider.create();
            final AwsCredentials firstAccess = backingCredentialsProvider.resolveCredentials();
            final AtomicReference<AwsCredentials> once = new AtomicReference<AwsCredentials>(firstAccess);
            return new AwsCredentialsProvider(){

                public AwsCredentials resolveCredentials() {
                    if (once.compareAndSet(firstAccess, null)) {
                        return firstAccess;
                    }
                    return backingCredentialsProvider.resolveCredentials();
                }
            };
        }
    }
}

