/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import com.google.auth.oauth2.GoogleCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.GcpIamCredentialsAuthentication;
import org.springframework.vault.authentication.GcpIamCredentialsAuthenticationOptions;
import org.springframework.web.client.RestOperations;

public class GcpIamClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public GcpIamClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.GCP_IAM);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        this.assertClassPresent("com.google.api.client.googleapis.auth.oauth2.GoogleCredential", this.missingClassForAuthMethod("GoogleCredential", "google-api-client", VaultEnvironmentProperties.AuthenticationMethod.GCP_IAM));
        VaultEnvironmentProperties.GcpIamProperties gcp = vaultProperties.getGcpIam();
        Assert.hasText((String)gcp.getRole(), (String)this.missingPropertyForAuthMethod("gcp-iam.role", VaultEnvironmentProperties.AuthenticationMethod.GCP_IAM));
        GcpIamCredentialsAuthenticationOptions.GcpIamCredentialsAuthenticationOptionsBuilder builder = GcpIamCredentialsAuthenticationOptions.builder().path(gcp.getGcpPath()).role(gcp.getRole()).jwtValidity(gcp.getJwtValidity());
        if (StringUtils.hasText((String)gcp.getProjectId())) {
            builder.serviceAccountId(gcp.getProjectId());
        }
        if (StringUtils.hasText((String)gcp.getServiceAccountId())) {
            builder.serviceAccountId(gcp.getServiceAccountId());
        }
        builder.credentials(GcpCredentialProvider.getGoogleCredential(gcp));
        GcpIamCredentialsAuthenticationOptions options = builder.build();
        return new GcpIamCredentialsAuthentication(options, vaultRestOperations);
    }

    private static class GcpCredentialProvider {
        private GcpCredentialProvider() {
        }

        public static GoogleCredentials getGoogleCredential(VaultEnvironmentProperties.GcpIamProperties gcp) {
            try {
                VaultEnvironmentProperties.GcpCredentials credentialProperties = gcp.getCredentials();
                if (credentialProperties.getLocation() != null) {
                    return GoogleCredentials.fromStream((InputStream)credentialProperties.getLocation().getInputStream());
                }
                if (StringUtils.hasText((String)credentialProperties.getEncodedKey())) {
                    return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(credentialProperties.getEncodedKey())));
                }
                return GoogleCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return GoogleCredentials.newBuilder().build();
            }
        }
    }
}

