/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.environment.PropertyValueDescriptor;

public class EnvironmentCleaner {
    public Environment clean(Environment value, String workingDir, String uri) {
        Environment result = new Environment(value);
        for (PropertySource source : value.getPropertySources()) {
            Object name = source.getName().replace(workingDir, "");
            name = ((String)name).replace("applicationConfig: [", "");
            name = uri + "/" + ((String)name).replace("]", "");
            result.add(new PropertySource((String)name, this.clean(source.getSource(), uri)));
        }
        return result;
    }

    protected Map<?, ?> clean(Map<?, ?> source, String uri) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (!(entry.getValue() instanceof PropertyValueDescriptor)) continue;
            PropertyValueDescriptor descriptor = (PropertyValueDescriptor)entry.getValue();
            if (!((String)uri).endsWith("/")) {
                uri = (String)uri + "/";
            }
            String updated = descriptor.getOrigin().replace("[", "[" + (String)uri);
            descriptor.setOrigin(updated);
        }
        return source;
    }
}

