/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health.reactive;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryHealthIndicator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import reactor.core.publisher.Mono;

public class ReactiveDiscoveryClientHealthIndicator
implements ReactiveDiscoveryHealthIndicator,
Ordered,
ApplicationListener<InstanceRegisteredEvent<?>> {
    private static final Log LOG = LogFactory.getLog(ReactiveDiscoveryClientHealthIndicator.class);
    private final ReactiveDiscoveryClient discoveryClient;
    private final DiscoveryClientHealthIndicatorProperties properties;
    private AtomicBoolean discoveryInitialized = new AtomicBoolean(false);
    private int order = Integer.MIN_VALUE;

    public ReactiveDiscoveryClientHealthIndicator(ReactiveDiscoveryClient discoveryClient, DiscoveryClientHealthIndicatorProperties properties) {
        this.discoveryClient = discoveryClient;
        this.properties = properties;
    }

    public void onApplicationEvent(InstanceRegisteredEvent<?> event) {
        if (this.discoveryInitialized.compareAndSet(false, true)) {
            LOG.debug((Object)"Discovery Client has been initialized");
        }
    }

    @Override
    public Mono<Health> health() {
        if (this.discoveryInitialized.get()) {
            return this.doHealthCheck();
        }
        return Mono.just((Object)Health.status((Status)new Status(Status.UNKNOWN.getCode(), "Discovery Client not initialized")).build());
    }

    private Mono<Health> doHealthCheck() {
        return Mono.just((Object)this.properties.isUseServicesQuery()).flatMap(useServices -> useServices != false ? this.doHealthCheckWithServices() : this.doHealthCheckWithProbe()).onErrorResume(exception -> {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error", exception);
            }
            return Mono.just((Object)Health.down().withException(exception).build());
        });
    }

    private Mono<Health> doHealthCheckWithProbe() {
        return this.discoveryClient.reactiveProbe().doOnError(exception -> {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Probe has failed.", exception);
            }
        }).then(this.buildHealthUp(this.discoveryClient));
    }

    private Mono<Health> buildHealthUp(ReactiveDiscoveryClient discoveryClient) {
        String description = this.properties.isIncludeDescription() ? discoveryClient.description() : "";
        return Mono.just((Object)Health.status((Status)new Status("UP", description)).build());
    }

    private Mono<Health> doHealthCheckWithServices() {
        return Mono.justOrEmpty((Object)this.discoveryClient).flatMapMany(ReactiveDiscoveryClient::getServices).collectList().defaultIfEmpty(Collections.emptyList()).map(services -> {
            String description = this.properties.isIncludeDescription() ? this.discoveryClient.description() : "";
            return Health.status((Status)new Status("UP", description)).withDetail("services", services).build();
        });
    }

    @Override
    public String getName() {
        return this.discoveryClient.description();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

