/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.Collection;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryHealthIndicator;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ReactiveCommonsClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class})
    @ConditionalOnClass(value={ReactiveHealthIndicator.class})
    @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnReactiveDiscoveryEnabled
    protected static class ReactiveDiscoveryLoadBalancerConfiguration {
        protected ReactiveDiscoveryLoadBalancerConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.discovery.client.composite-indicator.enabled"}, matchIfMissing=true)
        @ConditionalOnBean(value={ReactiveDiscoveryHealthIndicator.class})
        public ReactiveDiscoveryCompositeHealthContributor reactiveDiscoveryClients(Collection<ReactiveDiscoveryHealthIndicator> indicators) {
            return new ReactiveDiscoveryCompositeHealthContributor(indicators);
        }

        @Bean
        public HasFeatures reactiveCommonsFeatures() {
            return HasFeatures.abstractFeatures(ReactiveDiscoveryClient.class, ReactiveLoadBalancer.class);
        }
    }
}

