/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.client.discovery.simple.InstanceProperties;

@ConfigurationProperties(prefix="spring.cloud.discovery.client.simple")
public class SimpleReactiveDiscoveryProperties
implements InitializingBean {
    private Map<String, List<InstanceProperties>> instances = new HashMap<String, List<InstanceProperties>>();
    @NestedConfigurationProperty
    private InstanceProperties local = new InstanceProperties();
    private int order = 0;

    public List<InstanceProperties> getInstances(String service) {
        return this.instances.getOrDefault(service, Collections.emptyList());
    }

    Map<String, List<InstanceProperties>> getInstances() {
        return this.instances;
    }

    public void setInstances(Map<String, List<InstanceProperties>> instances) {
        this.instances = instances;
    }

    public InstanceProperties getLocal() {
        return this.local;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() {
        for (String key : this.instances.keySet()) {
            for (InstanceProperties instance : this.instances.get(key)) {
                instance.setServiceId(key);
            }
        }
    }
}

