/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.BlockingLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.ClientHttpResponseStatusCodeException;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestAdapter;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.client.loadbalancer.RetryableRequestContext;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class RetryLoadBalancerInterceptor
implements BlockingLoadBalancerInterceptor {
    private static final Log LOG = LogFactory.getLog(RetryLoadBalancerInterceptor.class);
    private final LoadBalancerClient loadBalancer;
    private final LoadBalancerRequestFactory requestFactory;
    private final LoadBalancedRetryFactory lbRetryFactory;
    private final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;

    public RetryLoadBalancerInterceptor(LoadBalancerClient loadBalancer, LoadBalancerRequestFactory requestFactory, LoadBalancedRetryFactory lbRetryFactory, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
        this.loadBalancer = loadBalancer;
        this.requestFactory = requestFactory;
        this.lbRetryFactory = lbRetryFactory;
        this.loadBalancerFactory = loadBalancerFactory;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        URI originalUri = request.getURI();
        String serviceName = originalUri.getHost();
        Assert.state((serviceName != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + String.valueOf(originalUri)));
        LoadBalancedRetryPolicy retryPolicy = this.lbRetryFactory.createRetryPolicy(serviceName, this.loadBalancer);
        RetryTemplate template = this.createRetryTemplate(serviceName, request, retryPolicy);
        return (ClientHttpResponse)template.execute(context -> {
            ServiceInstance serviceInstance = null;
            if (context instanceof LoadBalancedRetryContext) {
                LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                serviceInstance = lbContext.getServiceInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrieved service instance from LoadBalancedRetryContext: %s", serviceInstance));
                }
            }
            Set<LoadBalancerLifecycle> supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors(this.loadBalancerFactory.getInstances(serviceName, LoadBalancerLifecycle.class), RetryableRequestContext.class, ResponseData.class, ServiceInstance.class);
            String hint = this.getHint(serviceName);
            if (serviceInstance == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Service instance retrieved from LoadBalancedRetryContext: was null. Reattempting service instance selection");
                }
                ServiceInstance previousServiceInstance = null;
                if (context instanceof LoadBalancedRetryContext) {
                    LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                    previousServiceInstance = lbContext.getPreviousServiceInstance();
                }
                DefaultRequest<RetryableRequestContext> lbRequest = new DefaultRequest<RetryableRequestContext>(new RetryableRequestContext(previousServiceInstance, new RequestData(request), hint));
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart(lbRequest));
                serviceInstance = this.loadBalancer.choose(serviceName, lbRequest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Selected service instance: %s", serviceInstance));
                }
                if (context instanceof LoadBalancedRetryContext) {
                    LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                    lbContext.setServiceInstance(serviceInstance);
                }
                DefaultResponse lbResponse = new DefaultResponse(serviceInstance);
                if (serviceInstance == null) {
                    supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, new DefaultRequest<RetryableRequestContext>(new RetryableRequestContext(null, new RequestData(request), hint)), lbResponse)));
                }
            }
            LoadBalancerRequestAdapter<ClientHttpResponse, RetryableRequestContext> lbRequest = new LoadBalancerRequestAdapter<ClientHttpResponse, RetryableRequestContext>(this.requestFactory.createRequest(request, body, execution), new RetryableRequestContext(null, new RequestData(request), hint));
            ServiceInstance finalServiceInstance = serviceInstance;
            ClientHttpResponse response = (ClientHttpResponse)this.loadBalancer.execute(serviceName, finalServiceInstance, lbRequest);
            int statusCode = response.getStatusCode().value();
            if (retryPolicy != null && retryPolicy.retryableStatusCode(statusCode)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrying on status code: %d", statusCode));
                }
                byte[] bodyCopy = StreamUtils.copyToByteArray((InputStream)response.getBody());
                response.close();
                throw new ClientHttpResponseStatusCodeException(serviceName, response, bodyCopy);
            }
            return response;
        }, (RecoveryCallback)new LoadBalancedRecoveryCallback<ClientHttpResponse, ClientHttpResponse>(){

            @Override
            protected ClientHttpResponse createResponse(ClientHttpResponse response, URI uri) {
                return response;
            }
        });
    }

    private RetryTemplate createRetryTemplate(String serviceName, HttpRequest request, LoadBalancedRetryPolicy retryPolicy) {
        RetryTemplate template = new RetryTemplate();
        BackOffPolicy backOffPolicy = this.lbRetryFactory.createBackOffPolicy(serviceName);
        template.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        template.setThrowLastExceptionOnExhausted(true);
        RetryListener[] retryListeners = this.lbRetryFactory.createRetryListeners(serviceName);
        if (retryListeners != null && retryListeners.length != 0) {
            template.setListeners(retryListeners);
        }
        template.setRetryPolicy((RetryPolicy)(!this.loadBalancerFactory.getProperties(serviceName).getRetry().isEnabled() || retryPolicy == null ? new NeverRetryPolicy() : new InterceptorRetryPolicy(request, retryPolicy, this.loadBalancer, serviceName)));
        return template;
    }

    private String getHint(String serviceId) {
        Map<String, String> hint = this.loadBalancerFactory.getProperties(serviceId).getHint();
        String defaultHint = hint.getOrDefault("default", "default");
        String hintPropertyValue = hint.get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }
}

