/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery.reactive;

import java.util.HashMap;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;

public class CloudFoundryNativeReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final CloudFoundryService cloudFoundryService;
    private final CloudFoundryOperations cloudFoundryOperations;
    private final CloudFoundryDiscoveryProperties properties;

    CloudFoundryNativeReactiveDiscoveryClient(CloudFoundryOperations operations, CloudFoundryService svc, CloudFoundryDiscoveryProperties properties) {
        this.cloudFoundryService = svc;
        this.cloudFoundryOperations = operations;
        this.properties = properties;
    }

    public String description() {
        return "CF Reactive Service Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return this.cloudFoundryService.getApplicationInstances(serviceId).map(this::mapApplicationInstanceToServiceInstance);
    }

    public Flux<String> getServices() {
        return this.cloudFoundryOperations.applications().list().map(ApplicationSummary::getName);
    }

    public int getOrder() {
        return this.properties.getOrder();
    }

    protected ServiceInstance mapApplicationInstanceToServiceInstance(Tuple2<ApplicationDetail, InstanceDetail> tuple) {
        ApplicationDetail applicationDetail = (ApplicationDetail)tuple.getT1();
        InstanceDetail instanceDetail = (InstanceDetail)tuple.getT2();
        String applicationId = applicationDetail.getId();
        String applicationIndex = instanceDetail.getIndex();
        String instanceId = applicationId + "." + applicationIndex;
        String name = applicationDetail.getName();
        String url = applicationDetail.getUrls().size() > 0 ? (String)applicationDetail.getUrls().get(0) : null;
        boolean secure = (url + "").toLowerCase().startsWith("https");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("applicationId", applicationId);
        metadata.put("instanceId", applicationIndex);
        return new DefaultServiceInstance(instanceId, name, url, secure ? 443 : 80, secure, metadata);
    }
}

