/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import org.cloudfoundry.operations.CloudFoundryOperations;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryAppServiceDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryHeartbeatSender;
import org.springframework.cloud.cloudfoundry.discovery.ConditionalOnCloudFoundryDiscoveryEnabled;
import org.springframework.cloud.cloudfoundry.discovery.SimpleDnsBasedDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CloudFoundryOperations.class})
@ConditionalOnDiscoveryEnabled
@ConditionalOnBlockingDiscoveryEnabled
@ConditionalOnCloudFoundryDiscoveryEnabled
@EnableConfigurationProperties(value={CloudFoundryDiscoveryProperties.class})
public class CloudFoundryDiscoveryClientConfiguration {
    @Bean
    @ConditionalOnBean(value={CloudFoundryDiscoveryClient.class})
    public CloudFoundryHeartbeatSender cloudFoundryHeartbeatSender(CloudFoundryDiscoveryClient client) {
        return new CloudFoundryHeartbeatSender(client);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-dns"}, havingValue="true")
    public static class DnsBasedCloudFoundryDiscoveryClientConfig {
        @Bean
        @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-container-ip"}, havingValue="true")
        @ConditionalOnMissingBean(value={DiscoveryClient.class})
        public SimpleDnsBasedDiscoveryClient discoveryClient(ObjectProvider<SimpleDnsBasedDiscoveryClient.ServiceIdToHostnameConverter> provider, CloudFoundryDiscoveryProperties properties) {
            SimpleDnsBasedDiscoveryClient.ServiceIdToHostnameConverter converter = (SimpleDnsBasedDiscoveryClient.ServiceIdToHostnameConverter)provider.getIfAvailable();
            return converter == null ? new SimpleDnsBasedDiscoveryClient(properties) : new SimpleDnsBasedDiscoveryClient(properties, converter);
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-container-ip"}, havingValue="false", matchIfMissing=true)
        @ConditionalOnMissingBean(value={DiscoveryClient.class})
        public CloudFoundryAppServiceDiscoveryClient cloudFoundryDiscoveryClient(CloudFoundryOperations cf, CloudFoundryService svc, CloudFoundryDiscoveryProperties properties) {
            return new CloudFoundryAppServiceDiscoveryClient(cf, svc, properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.cloudfoundry.discovery.use-dns"}, havingValue="false", matchIfMissing=true)
    public static class CloudFoundryDiscoveryClientConfig {
        @Bean
        @ConditionalOnMissingBean(value={DiscoveryClient.class})
        public CloudFoundryDiscoveryClient cloudFoundryDiscoveryClient(CloudFoundryOperations cf, CloudFoundryService svc, CloudFoundryDiscoveryProperties cloudFoundryDiscoveryProperties) {
            return new CloudFoundryDiscoveryClient(cf, svc, cloudFoundryDiscoveryProperties);
        }
    }
}

