/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery.reactive;

import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.reactive.CloudFoundryNativeReactiveDiscoveryClient;
import reactor.core.publisher.Flux;

public class CloudFoundryAppServiceReactiveDiscoveryClient
extends CloudFoundryNativeReactiveDiscoveryClient {
    private static final String INTERNAL_DOMAIN = "apps.internal";
    private final CloudFoundryService cloudFoundryService;

    CloudFoundryAppServiceReactiveDiscoveryClient(CloudFoundryOperations cloudFoundryOperations, CloudFoundryService svc, CloudFoundryDiscoveryProperties cloudFoundryDiscoveryProperties) {
        super(cloudFoundryOperations, svc, cloudFoundryDiscoveryProperties);
        this.cloudFoundryService = svc;
    }

    @Override
    public String description() {
        return "CF App Reactive Service Discovery Client";
    }

    @Override
    public Flux<ServiceInstance> getInstances(String serviceId) {
        return this.cloudFoundryService.getApplicationInstances(serviceId).filter(tuple -> ((ApplicationDetail)tuple.getT1()).getUrls().stream().anyMatch(this::isInternalDomain)).map(this::mapApplicationInstanceToServiceInstance);
    }

    private boolean isInternalDomain(String url) {
        return url != null && url.endsWith(INTERNAL_DOMAIN);
    }
}

