/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryServer;
import org.springframework.cloud.netflix.ribbon.RibbonProperties;
import org.springframework.util.Assert;

public class CloudFoundryServerList
extends AbstractServerList<CloudFoundryServer> {
    private final CloudFoundryService cloudFoundryService;
    private final CloudFoundryDiscoveryProperties properties;
    private IClientConfig clientConfig;
    private String serviceId;

    CloudFoundryServerList(CloudFoundryService svc, CloudFoundryDiscoveryProperties properties) {
        this.cloudFoundryService = svc;
        this.properties = properties;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.serviceId = clientConfig.getClientName();
    }

    public List<CloudFoundryServer> getInitialListOfServers() {
        return this.cloudFoundryServers();
    }

    public List<CloudFoundryServer> getUpdatedListOfServers() {
        return this.cloudFoundryServers();
    }

    private List<CloudFoundryServer> cloudFoundryServers() {
        Assert.notNull((Object)this.clientConfig, (String)"clientConfig may not be null");
        RibbonProperties ribbon = RibbonProperties.from((IClientConfig)this.clientConfig);
        Boolean secure = ribbon.getSecure();
        Integer securePort = ribbon.getSecurePort();
        Integer nonSecurePort = ribbon.getPort();
        int port = secure != null && secure != false && securePort != null ? securePort : (nonSecurePort != null ? nonSecurePort.intValue() : this.properties.getDefaultServerPort());
        return this.cloudFoundryService.getApplicationInstances(this.serviceId).map(tpl -> new CloudFoundryServer(((ApplicationDetail)tpl.getT1()).getName(), (String)((ApplicationDetail)tpl.getT1()).getUrls().get(0), port)).collectList().blockOptional().orElse(new ArrayList());
    }

    String getServiceId() {
        return this.serviceId;
    }
}

