/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import java.util.List;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryClient;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryHeartbeatSender
implements ApplicationEventPublisherAware {
    private final CloudFoundryDiscoveryClient client;
    private ApplicationEventPublisher publisher;

    public CloudFoundryHeartbeatSender(CloudFoundryDiscoveryClient client) {
        this.client = client;
    }

    @Scheduled(fixedDelayString="${spring.cloud.cloudfoundry.discovery.heartbeatFrequency:5000}")
    public void poll() {
        if (this.publisher != null) {
            List<String> services = this.client.getServices();
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this.client, services));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

