/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.InstanceInfo;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.env.Environment;

public class CloudFoundryDiscoveryClient
implements DiscoveryClient {
    private static final String DESCRIPTION = "Cloud Foundry " + DiscoveryClient.class.getName() + " implementation";
    private static final Log log = LogFactory.getLog(CloudFoundryDiscoveryClient.class);
    private final CloudFoundryClient cloudFoundryClient;
    @Value(value="${vcap.application.name:${spring.application.name:application}}")
    private String vcapApplicationName = "application";

    public CloudFoundryDiscoveryClient(CloudFoundryClient cloudFoundryClient, Environment environment) {
        this.cloudFoundryClient = cloudFoundryClient;
    }

    public String description() {
        return DESCRIPTION;
    }

    public ServiceInstance getLocalServiceInstance() {
        List<ServiceInstance> serviceInstances = null;
        try {
            CloudApplication application = this.cloudFoundryClient.getApplication(this.vcapApplicationName);
            serviceInstances = this.createServiceInstancesFromCloudApplications(Collections.singletonList(application));
        }
        catch (Exception e) {
            log.warn((Object)("Could not determine local service instance: " + e.getClass() + " (" + e.getMessage() + ")"));
        }
        return serviceInstances != null && serviceInstances.size() > 0 ? serviceInstances.iterator().next() : null;
    }

    public List<ServiceInstance> getInstances(String s) {
        try {
            CloudApplication applications = this.cloudFoundryClient.getApplication(s);
            return this.createServiceInstancesFromCloudApplications(Collections.singletonList(applications));
        }
        catch (Exception e) {
            log.warn((Object)("Could not get service instances: " + e.getClass() + " (" + e.getMessage() + ")"));
            return Collections.emptyList();
        }
    }

    private boolean isRunning(CloudApplication ca) {
        List instances;
        InstancesInfo ii = this.cloudFoundryClient.getApplicationInstances(ca);
        if (ii != null && (instances = ii.getInstances()) != null) {
            for (InstanceInfo resolved : instances) {
                InstanceState state = resolved.getState();
                if (state == null || !state.equals((Object)InstanceState.RUNNING)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getServices() {
        List<CloudApplication> applications;
        ArrayList<String> services = new ArrayList<String>();
        try {
            applications = this.cloudFoundryClient.getApplications();
        }
        catch (Exception e) {
            log.warn((Object)("Could not get applications: " + e.getClass() + " (" + e.getMessage() + ")"));
            applications = Collections.emptyList();
        }
        HashSet<String> serviceIds = new HashSet<String>();
        for (CloudApplication ca : applications) {
            if (!this.isRunning(ca)) continue;
            serviceIds.add(ca.getName());
        }
        services.addAll(serviceIds);
        return services;
    }

    protected List<ServiceInstance> createServiceInstancesFromCloudApplications(Collection<CloudApplication> cloudApplications) {
        HashSet<CloudFoundryServiceInstance> serviceInstances = new HashSet<CloudFoundryServiceInstance>();
        for (CloudApplication ca : cloudApplications) {
            if (!this.isRunning(ca)) continue;
            serviceInstances.add(new CloudFoundryServiceInstance(ca));
        }
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        instances.addAll(serviceInstances);
        return instances;
    }

    public static class CloudFoundryServiceInstance
    extends DefaultServiceInstance {
        private final CloudApplication cloudApplication;

        public CloudApplication getCloudApplication() {
            return this.cloudApplication;
        }

        public CloudFoundryServiceInstance(CloudApplication ca) {
            super(ca.getName(), ca.getUris().isEmpty() ? "localhost" : (String)ca.getUris().iterator().next(), 80, false);
            this.cloudApplication = ca;
        }
    }
}

