/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.command.encrypt;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.util.Log;
import org.springframework.cloud.cli.command.encrypt.EncryptorFactory;
import org.springframework.cloud.cli.command.encrypt.MissingKeyException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.StreamUtils;

class BaseEncryptOptionHandler
extends OptionHandler {
    private OptionSpec<String> keyOption;
    private OptionSpec<String> aliasOption;
    private OptionSpec<String> passwordOption;
    private OptionSpec<String> keyPassOption;
    private Charset charset = Charset.forName("UTF-8");

    BaseEncryptOptionHandler() {
    }

    protected final void options() {
        this.keyOption = this.option(Arrays.asList("key", "k"), "Specify key (symmetric secret, or pem-encoded key). If the value starts with @ it is interpreted as a file location.").withRequiredArg();
        this.passwordOption = this.option("password", "A password for the keyfile (assuming the --key option is a KeyStore file).").withRequiredArg();
        this.keyPassOption = this.option("keypass", "A password for the key, defaults to the same as the store password (assuming the --key option is a KeyStore file).").withRequiredArg();
        this.aliasOption = this.option("alias", "An alias for the the key in a keyfile (assuming the --key option is a KeyStore file).").withRequiredArg();
        this.doOptions();
    }

    protected void doOptions() {
    }

    protected TextEncryptor createEncryptor(OptionSet options) {
        String value = (String)this.keyOption.value(options);
        if (value == null) {
            throw new MissingKeyException();
        }
        if (options.has(this.passwordOption)) {
            String password = (String)options.valueOf(this.passwordOption);
            String alias = (String)options.valueOf(this.aliasOption);
            KeyStoreKeyFactory factory = new KeyStoreKeyFactory((Resource)new FileSystemResource(value), password.toCharArray());
            if (options.has(this.keyPassOption)) {
                String keypass = (String)options.valueOf(this.keyPassOption);
                RsaSecretEncryptor encryptor = new RsaSecretEncryptor(factory.getKeyPair(alias, keypass.toCharArray()));
                return encryptor;
            }
            RsaSecretEncryptor encryptor = new RsaSecretEncryptor(factory.getKeyPair(alias));
            return encryptor;
        }
        boolean verbose = Boolean.getBoolean("debug");
        if (value.startsWith("@")) {
            value = this.readFile(value.substring(1));
        }
        try {
            value = this.readFile(value);
            if (verbose) {
                int len = Math.min(100, Math.max(value.length(), value.indexOf("\n")));
                Log.info((String)("File contents:\n" + value.substring(0, len) + "..."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new EncryptorFactory(verbose).create(value.trim());
    }

    private String readFile(String filename) {
        try {
            return StreamUtils.copyToString((InputStream)new FileInputStream(new File(filename)), (Charset)this.charset);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

