/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetricsPublisher;
import io.github.resilience4j.micrometer.tagged.TaggedThreadPoolBulkheadMetrics;
import io.github.resilience4j.springboot3.circuitbreaker.autoconfigure.CircuitBreakerMetricsAutoConfiguration;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.observation.ObservationRegistry;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigurationProperties;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadProvider;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Resilience4JConfigurationProperties.class})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.resilience4j.enabled", "spring.cloud.circuitbreaker.resilience4j.blocking.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={CircuitBreakerMetricsAutoConfiguration.class})
public class Resilience4JAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<Resilience4JCircuitBreakerFactory>> customizers = new ArrayList<Customizer<Resilience4JCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public Resilience4JCircuitBreakerFactory resilience4jCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, @Autowired(required=false) Resilience4jBulkheadProvider bulkheadProvider, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
        Resilience4JCircuitBreakerFactory factory = new Resilience4JCircuitBreakerFactory(circuitBreakerRegistry, timeLimiterRegistry, bulkheadProvider, resilience4JConfigurationProperties);
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ObservationRegistry.class})
    public static class ObservationRegistryCustomizerResilience4jCustomizer {
        @Autowired
        ObservationRegistry observationRegistry;
        @Autowired(required=false)
        private Resilience4JCircuitBreakerFactory factory;

        @PostConstruct
        public void init() {
            if (this.factory != null) {
                this.factory.setObservationRegistry(this.observationRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnClass(name={"io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics", "io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetricsPublisher"})
    @ConditionalOnMissingBean(value={TaggedCircuitBreakerMetricsPublisher.class})
    public static class MicrometerResilience4JCustomizerConfiguration {
        @Autowired(required=false)
        private Resilience4JCircuitBreakerFactory factory;
        @Autowired(required=false)
        private Resilience4jBulkheadProvider bulkheadProvider;
        @Autowired(required=false)
        private TaggedCircuitBreakerMetrics taggedCircuitBreakerMetrics;
        @Autowired
        private MeterRegistry meterRegistry;

        @PostConstruct
        public void init() {
            if (this.factory != null) {
                if (this.taggedCircuitBreakerMetrics == null) {
                    this.taggedCircuitBreakerMetrics = TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)this.factory.getCircuitBreakerRegistry());
                }
                this.taggedCircuitBreakerMetrics.bindTo(this.meterRegistry);
            }
            if (this.bulkheadProvider != null) {
                TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)this.bulkheadProvider.getBulkheadRegistry()).bindTo(this.meterRegistry);
                TaggedThreadPoolBulkheadMetrics.ofThreadPoolBulkheadRegistry((ThreadPoolBulkheadRegistry)this.bulkheadProvider.getThreadPoolBulkheadRegistry()).bindTo(this.meterRegistry);
            }
            if (this.bulkheadProvider != null) {
                TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)this.bulkheadProvider.getBulkheadRegistry()).bindTo(this.meterRegistry);
                TaggedThreadPoolBulkheadMetrics.ofThreadPoolBulkheadRegistry((ThreadPoolBulkheadRegistry)this.bulkheadProvider.getThreadPoolBulkheadRegistry()).bindTo(this.meterRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    public static class MicrometerResilience4JGroupCustomizerConfiguration {
        private static final String RESILIENCE4J_METER_PREFIX = "resilience4j";

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.circuitbreaker.resilience4j.enableGroupMeterFilter"}, havingValue="true", matchIfMissing=true)
        MeterFilter resilience4JMeterFilter(final Resilience4JConfigurationProperties properties) {
            return new MeterFilter(){

                public Meter.Id map(Meter.Id id) {
                    if (id.getName().startsWith(MicrometerResilience4JGroupCustomizerConfiguration.RESILIENCE4J_METER_PREFIX) && id.getTag("group") == null) {
                        return id.withTag(Tag.of((String)"group", (String)properties.getDefaultGroupTag()));
                    }
                    return id;
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Bulkhead.class})
    @ConditionalOnProperty(value={"spring.cloud.circuitbreaker.bulkhead.resilience4j.enabled"}, matchIfMissing=true)
    public static class Resilience4jBulkheadConfiguration {
        @Autowired(required=false)
        private List<Customizer<Resilience4jBulkheadProvider>> bulkheadCustomizers = new ArrayList<Customizer<Resilience4jBulkheadProvider>>();

        @Bean
        public Resilience4jBulkheadProvider bulkheadProvider(ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, BulkheadRegistry bulkheadRegistry, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
            Resilience4jBulkheadProvider resilience4jBulkheadProvider = new Resilience4jBulkheadProvider(threadPoolBulkheadRegistry, bulkheadRegistry, resilience4JConfigurationProperties);
            this.bulkheadCustomizers.forEach(customizer -> customizer.customize((Object)resilience4jBulkheadProvider));
            return resilience4jBulkheadProvider;
        }
    }
}

