/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator"})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.resilience4j.enabled", "spring.cloud.circuitbreaker.resilience4j.reactive.enabled"}, matchIfMissing=true)
public class ReactiveResilience4JAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<ReactiveResilience4JCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactiveResilience4JCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    public ReactiveResilience4JCircuitBreakerFactory reactiveResilience4JCircuitBreakerFactory() {
        ReactiveResilience4JCircuitBreakerFactory factory = new ReactiveResilience4JCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics"})
    @ConditionalOnBean(value={MeterRegistry.class})
    public static class MicrometerReactiveResilience4JCustomizerConfiguration {
        @Autowired(required=false)
        private ReactiveResilience4JCircuitBreakerFactory factory;
        @Autowired
        private MeterRegistry meterRegistry;

        @PostConstruct
        public void init() {
            if (this.factory != null) {
                TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)this.factory.getCircuitBreakerRegistry()).bindTo(this.meterRegistry);
            }
        }
    }
}

