/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreaker;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.util.Assert;

public class Resilience4JCircuitBreakerFactory
extends CircuitBreakerFactory<Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration, Resilience4JConfigBuilder> {
    private Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig(CircuitBreakerConfig.ofDefaults()).timeLimiterConfig(TimeLimiterConfig.ofDefaults()).build();
    private CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Map<String, Customizer<CircuitBreaker>> circuitBreakerCustomizers = new HashMap<String, Customizer<CircuitBreaker>>();

    protected Resilience4JConfigBuilder configBuilder(String id) {
        return new Resilience4JConfigBuilder(id);
    }

    public void configureDefault(Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configureCircuitBreakerRegistry(CircuitBreakerRegistry registry) {
        this.circuitBreakerRegistry = registry;
    }

    protected CircuitBreakerRegistry getCircuitBreakerRegistry() {
        return this.circuitBreakerRegistry;
    }

    public void configureExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Resilience4JCircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        return new Resilience4JCircuitBreaker(id, config.getCircuitBreakerConfig(), config.getTimeLimiterConfig(), this.circuitBreakerRegistry, this.executorService, Optional.ofNullable(this.circuitBreakerCustomizers.get(id)));
    }

    public void addCircuitBreakerCustomizer(Customizer<CircuitBreaker> customizer, String ... ids) {
        for (String id : ids) {
            this.circuitBreakerCustomizers.put(id, customizer);
        }
    }
}

