/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.vavr.control.Try;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.Customizer;

public class Resilience4JCircuitBreaker
implements org.springframework.cloud.client.circuitbreaker.CircuitBreaker {
    private String id;
    private CircuitBreakerConfig circuitBreakerConfig;
    private CircuitBreakerRegistry registry;
    private TimeLimiterConfig timeLimiterConfig;
    private ExecutorService executorService;
    private Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer;

    public Resilience4JCircuitBreaker(String id, CircuitBreakerConfig circuitBreakerConfig, TimeLimiterConfig timeLimiterConfig, CircuitBreakerRegistry circuitBreakerRegistry, ExecutorService executorService, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer) {
        this.id = id;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.registry = circuitBreakerRegistry;
        this.timeLimiterConfig = timeLimiterConfig;
        this.executorService = executorService;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
    }

    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        TimeLimiter timeLimiter = TimeLimiter.of((TimeLimiterConfig)this.timeLimiterConfig);
        Supplier<Future> futureSupplier = () -> this.executorService.submit(((Supplier)toRun)::get);
        Callable restrictedCall = TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, futureSupplier);
        CircuitBreaker defaultCircuitBreaker = this.registry.circuitBreaker(this.id, this.circuitBreakerConfig);
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        Callable callable = CircuitBreaker.decorateCallable((CircuitBreaker)defaultCircuitBreaker, (Callable)restrictedCall);
        return (T)Try.of(callable::call).recover(fallback).get();
    }
}

