/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.bus.BusBridge;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.AckRemoteApplicationEvent;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.SentApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class BusConsumer
implements Consumer<RemoteApplicationEvent> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ApplicationEventPublisher publisher;
    private final ServiceMatcher serviceMatcher;
    private final ObjectProvider<BusBridge> busBridge;
    private final BusProperties properties;
    private final Destination.Factory destinationFactory;

    public BusConsumer(ApplicationEventPublisher publisher, ServiceMatcher serviceMatcher, ObjectProvider<BusBridge> busBridge, BusProperties properties, Destination.Factory destinationFactory) {
        this.publisher = publisher;
        this.serviceMatcher = serviceMatcher;
        this.busBridge = busBridge;
        this.properties = properties;
        this.destinationFactory = destinationFactory;
    }

    @Override
    public void accept(RemoteApplicationEvent event) {
        if (event instanceof AckRemoteApplicationEvent) {
            if (this.properties.getTrace().isEnabled() && !this.serviceMatcher.isFromSelf(event) && this.publisher != null) {
                this.publisher.publishEvent((ApplicationEvent)event);
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received remote event from bus: " + String.valueOf((Object)event)));
        }
        if (this.serviceMatcher.isForSelf(event) && this.publisher != null) {
            if (!this.serviceMatcher.isFromSelf(event)) {
                this.publisher.publishEvent((ApplicationEvent)event);
            }
            if (this.properties.getAck().isEnabled()) {
                AckRemoteApplicationEvent ack = new AckRemoteApplicationEvent(this, this.serviceMatcher.getBusId(), this.destinationFactory.getDestination(this.properties.getAck().getDestinationService()), event.getDestinationService(), event.getId(), ((Object)((Object)event)).getClass());
                this.busBridge.ifAvailable(bridge -> bridge.send(ack));
                this.publisher.publishEvent((ApplicationEvent)ack);
            }
        }
        if (this.properties.getTrace().isEnabled() && this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new SentApplicationEvent(this, event.getOriginService(), event.getDestinationService(), event.getId(), ((Object)((Object)event)).getClass()));
        }
    }
}

