/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.util.PathMatcher;

public class PathServiceMatcher
implements ServiceMatcher {
    private final PathMatcher matcher;
    private final String id;
    private String[] configNames = new String[0];

    public PathServiceMatcher(PathMatcher matcher, String id) {
        this.matcher = matcher;
        this.id = id;
    }

    public PathServiceMatcher(PathMatcher matcher, String id, String[] configNames) {
        this(matcher, id);
        int colonIndex = id.indexOf(":");
        if (colonIndex >= 0) {
            String profilesAndPort = id.substring(colonIndex);
            for (int i = 0; i < configNames.length; ++i) {
                configNames[i] = configNames[i] + profilesAndPort;
            }
        }
        this.configNames = configNames;
    }

    @Override
    public boolean isFromSelf(RemoteApplicationEvent event) {
        String originService = event.getOriginService();
        String serviceId = this.getBusId();
        return this.matcher.match(originService, serviceId);
    }

    @Override
    public boolean isForSelf(RemoteApplicationEvent event) {
        String destinationService = event.getDestinationService();
        if (destinationService == null || destinationService.trim().isEmpty() || this.matcher.match(destinationService, this.getBusId())) {
            return true;
        }
        for (String configName : this.configNames) {
            if (!this.matcher.match(destinationService, configName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getBusId() {
        return this.id;
    }
}

