/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.UnknownRemoteApplicationEvent;
import org.springframework.cloud.bus.jackson.SubtypeModule;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;

class BusJacksonMessageConverter
extends AbstractMessageConverter
implements InitializingBean {
    private static final Log log = LogFactory.getLog(BusJacksonMessageConverter.class);
    private static final String DEFAULT_PACKAGE = ClassUtils.getPackageName(RemoteApplicationEvent.class);
    private final ObjectMapper mapper;
    private final boolean mapperCreated;
    private String[] packagesToScan = new String[]{DEFAULT_PACKAGE};

    private BusJacksonMessageConverter() {
        this(null);
    }

    @Autowired(required=false)
    BusJacksonMessageConverter(@Nullable ObjectMapper objectMapper) {
        super(MimeTypeUtils.APPLICATION_JSON);
        if (objectMapper != null) {
            this.mapper = objectMapper;
            this.mapperCreated = false;
        } else {
            this.mapper = new ObjectMapper();
            this.mapperCreated = true;
        }
    }

    boolean isMapperCreated() {
        return this.mapperCreated;
    }

    ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(packagesToScan));
        if (!packages.contains(DEFAULT_PACKAGE)) {
            packages.add(DEFAULT_PACKAGE);
        }
        this.packagesToScan = packages.toArray(new String[0]);
    }

    private Class<?>[] findSubTypes() {
        ArrayList types = new ArrayList();
        if (this.packagesToScan != null) {
            for (String pkg : this.packagesToScan) {
                ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
                provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(RemoteApplicationEvent.class));
                Set components = provider.findCandidateComponents(pkg);
                for (BeanDefinition component : components) {
                    try {
                        types.add(Class.forName(component.getBeanClassName()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Failed to scan classpath for remote event classes", e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found sub types: " + types));
        }
        return types.toArray(new Class[0]);
    }

    protected boolean supports(Class<?> aClass) {
        return RemoteApplicationEvent.class.isAssignableFrom(aClass);
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object result;
        block9: {
            result = null;
            try {
                Object payload = message.getPayload();
                if (payload instanceof byte[]) {
                    try {
                        result = this.mapper.readValue((byte[])payload, targetClass);
                        break block9;
                    }
                    catch (InvalidTypeIdException e) {
                        return new UnknownRemoteApplicationEvent(new Object(), e.getTypeId(), (byte[])payload);
                    }
                }
                if (payload instanceof String) {
                    try {
                        result = this.mapper.readValue((String)payload, targetClass);
                        break block9;
                    }
                    catch (InvalidTypeIdException e) {
                        return new UnknownRemoteApplicationEvent(new Object(), e.getTypeId(), ((String)payload).getBytes());
                    }
                }
                if (payload instanceof RemoteApplicationEvent) {
                    return payload;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        this.mapper.registerModule((Module)new SubtypeModule(this.findSubTypes()));
    }
}

