/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.util.PathMatcher;

public class ServiceMatcher {
    private final PathMatcher matcher;
    private final String id;
    private String[] configNames = new String[0];

    public ServiceMatcher(PathMatcher matcher, String id) {
        this.matcher = matcher;
        this.id = id;
    }

    public ServiceMatcher(PathMatcher matcher, String id, String[] configNames) {
        this(matcher, id);
        int colonIndex = id.indexOf(":");
        if (colonIndex >= 0) {
            String profilesAndPort = id.substring(colonIndex);
            for (int i = 0; i < configNames.length; ++i) {
                configNames[i] = configNames[i] + profilesAndPort;
            }
        }
        this.configNames = configNames;
    }

    public boolean isFromSelf(RemoteApplicationEvent event) {
        String originService = event.getOriginService();
        String serviceId = this.getServiceId();
        return this.matcher.match(originService, serviceId);
    }

    public boolean isForSelf(RemoteApplicationEvent event) {
        String destinationService = event.getDestinationService();
        if (destinationService == null || destinationService.trim().isEmpty() || this.matcher.match(destinationService, this.getServiceId())) {
            return true;
        }
        for (String configName : this.configNames) {
            if (!this.matcher.match(destinationService, configName)) continue;
            return true;
        }
        return false;
    }

    public String getServiceId() {
        return this.id;
    }
}

