/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.amqp.AmqpBusProperties;
import org.springframework.cloud.bus.amqp.BusConnectionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.messaging.MessageChannel;

@Configuration
@ConditionalOnBusEnabled
@ConditionalOnClass(value={AmqpTemplate.class, RabbitTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.bus.amqp.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AmqpBusProperties.class})
public class AmqpBusAutoConfiguration {
    @Autowired
    private AmqpBusProperties bus;
    @Autowired(required=false)
    @BusConnectionFactory
    private ConnectionFactory busConnectionFactory;
    @Autowired(required=false)
    private ConnectionFactory primaryConnectionFactory;
    @Autowired
    private ApplicationContext context;
    private RabbitTemplate amqpTemplate;
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    public RabbitTemplate amqpTemplate() {
        if (this.amqpTemplate == null) {
            RabbitTemplate amqpTemplate = new RabbitTemplate(this.connectionFactory());
            Jackson2JsonMessageConverter converter = this.messageConverter();
            amqpTemplate.setMessageConverter((MessageConverter)converter);
            this.amqpTemplate = amqpTemplate;
            RabbitAdmin amqpAdmin = new RabbitAdmin(this.connectionFactory());
            this.cloudBusExchange().setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            this.localCloudBusQueueBinding().setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            this.localCloudBusQueue().setAdminsThatShouldDeclare(new Object[]{amqpAdmin});
            amqpAdmin.setApplicationContext(this.context);
            amqpAdmin.afterPropertiesSet();
        }
        return this.amqpTemplate;
    }

    @Bean
    protected FanoutExchange cloudBusExchange() {
        FanoutExchange exchange = new FanoutExchange(this.bus.getExchange());
        return exchange;
    }

    @Bean
    protected Binding localCloudBusQueueBinding() {
        return BindingBuilder.bind((Queue)this.localCloudBusQueue()).to(this.cloudBusExchange());
    }

    @Bean
    protected Queue localCloudBusQueue() {
        return new AnonymousQueue();
    }

    @Bean
    public IntegrationFlow cloudBusAmqpOutboundFlow(@Qualifier(value="cloudBusOutboundChannel") MessageChannel cloudBusOutboundChannel) {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)cloudBusOutboundChannel).handle((MessageHandlerSpec)Amqp.outboundAdapter((AmqpTemplate)this.amqpTemplate()).exchangeName(this.bus.getExchange()))).get();
    }

    @Bean
    public IntegrationFlow cloudBusAmqpInboundFlow(@Qualifier(value="cloudBusInboundChannel") MessageChannel cloudBusInboundChannel) {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((MessageProducerSpec)Amqp.inboundAdapter((ConnectionFactory)this.connectionFactory(), (Queue[])new Queue[]{this.localCloudBusQueue()}).messageConverter((MessageConverter)this.messageConverter())).channel(cloudBusInboundChannel)).get();
    }

    private ConnectionFactory connectionFactory() {
        if (this.busConnectionFactory != null) {
            return this.busConnectionFactory;
        }
        return this.primaryConnectionFactory;
    }

    private Jackson2JsonMessageConverter messageConverter() {
        Jackson2JsonMessageConverter converter = new Jackson2JsonMessageConverter();
        if (this.objectMapper != null) {
            converter.setJsonObjectMapper(this.objectMapper);
        }
        return converter;
    }
}

