/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Random;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.cloud.bindings.boot.pem.PemSslStoreHelper;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

final class EurekaBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "eureka";

    EurekaBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            Map<String, String> secret = binding.getSecret();
            MapMapper map = new MapMapper(secret, properties);
            map.from("client-id").to("eureka.client.oauth2.client-id");
            map.from("access-token-uri").to("eureka.client.oauth2.access-token-uri");
            map.from("uri").to("eureka.client.serviceUrl.defaultZone", uri -> String.format("%s/eureka/", uri));
            properties.put("eureka.client.region", "default");
            String caCert = secret.get("ca.crt");
            if (caCert != null && !caCert.isEmpty()) {
                if (!environment.containsProperty("eureka.instance.preferIpAddress")) {
                    properties.put("eureka.instance.preferIpAddress", true);
                }
                Random random = new Random();
                String generatedPassword = random.ints(97, 123).limit(10L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
                String trustFilePath = Paths.get(System.getProperty("java.io.tmpdir"), "client-truststore.p12").toString();
                KeyStore trustStore = PemSslStoreHelper.createKeyStore("trust", "PKCS12", caCert, null, "rootca");
                EurekaBindingsPropertiesProcessor.createStoreFile("truststore", generatedPassword, trustFilePath, trustStore);
                properties.put("eureka.client.tls.enabled", true);
                properties.put("eureka.client.tls.trust-store", "file:" + trustFilePath);
                properties.put("eureka.client.tls.trust-store-type", "PKCS12");
                properties.put("eureka.client.tls.trust-store-password", generatedPassword);
                String clientKey = secret.get("tls.key");
                String clientCert = secret.get("tls.crt");
                if (StringUtils.hasText((String)clientCert) != StringUtils.hasText((String)clientKey)) {
                    throw new IllegalArgumentException("binding secret error: tls.key and tls.crt must both be set if either is set");
                }
                if (clientKey != null && !clientKey.isEmpty()) {
                    String keyFilePath = Paths.get(System.getProperty("java.io.tmpdir"), "client-keystore.p12").toString();
                    KeyStore keyStore = PemSslStoreHelper.createKeyStore("key", "PKCS12", clientCert, clientKey, TYPE);
                    EurekaBindingsPropertiesProcessor.createStoreFile("keystore", generatedPassword, keyFilePath, keyStore);
                    properties.put("eureka.client.tls.key-alias", TYPE);
                    properties.put("eureka.client.tls.key-store", "file:" + keyFilePath);
                    properties.put("eureka.client.tls.key-store-type", "PKCS12");
                    properties.put("eureka.client.tls.key-store-password", generatedPassword);
                    properties.put("eureka.client.tls.key-password", "");
                }
            }
        });
    }

    private static void createStoreFile(String storeType, String generatedPassword, String filePath, KeyStore ks) {
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            try {
                ks.store(fos, generatedPassword.toCharArray());
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("Unable to write " + storeType, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Cryptographic algorithm not available", e);
            }
            catch (CertificateException e) {
                throw new IllegalStateException("Unable to process certificate", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create " + storeType, e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to close " + storeType + " output file", e);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Unable to open " + storeType + " output file", e);
        }
    }
}

