/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.listener.support;

import org.springframework.cloud.aws.messaging.listener.Visibility;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;

public class VisibilityHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final String visibilityHeaderName;

    public VisibilityHandlerMethodArgumentResolver(String visibilityHeaderName) {
        this.visibilityHeaderName = visibilityHeaderName;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable(Visibility.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        if (!message.getHeaders().containsKey((Object)this.visibilityHeaderName) || message.getHeaders().get((Object)this.visibilityHeaderName) == null) {
            throw new IllegalArgumentException("No visibility object found for message header: '" + this.visibilityHeaderName + "'");
        }
        return message.getHeaders().get((Object)this.visibilityHeaderName);
    }
}

