/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.cloud.aws.messaging.core.SqsMessageHeaders;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public final class QueueMessageUtils {
    private static final String RECEIPT_HANDLE_MESSAGE_ATTRIBUTE_NAME = "ReceiptHandle";
    private static final String MESSAGE_ID_MESSAGE_ATTRIBUTE_NAME = "MessageId";

    private QueueMessageUtils() {
    }

    public static org.springframework.messaging.Message<String> createMessage(Message message) {
        return QueueMessageUtils.createMessage(message, Collections.emptyMap());
    }

    public static org.springframework.messaging.Message<String> createMessage(Message message, Map<String, Object> additionalHeaders) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        messageHeaders.put(MESSAGE_ID_MESSAGE_ATTRIBUTE_NAME, message.getMessageId());
        messageHeaders.put(RECEIPT_HANDLE_MESSAGE_ATTRIBUTE_NAME, message.getReceiptHandle());
        messageHeaders.putAll(additionalHeaders);
        messageHeaders.putAll(QueueMessageUtils.getAttributesAsMessageHeaders(message));
        messageHeaders.putAll(QueueMessageUtils.getMessageAttributesAsMessageHeaders(message));
        return new GenericMessage((Object)message.getBody(), (MessageHeaders)new SqsMessageHeaders(messageHeaders));
    }

    private static Map<String, Object> getAttributesAsMessageHeaders(Message message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        for (Map.Entry attributeKeyValuePair : message.getAttributes().entrySet()) {
            messageHeaders.put((String)attributeKeyValuePair.getKey(), attributeKeyValuePair.getValue());
        }
        return messageHeaders;
    }

    private static Map<String, Object> getMessageAttributesAsMessageHeaders(Message message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        for (Map.Entry messageAttribute : message.getMessageAttributes().entrySet()) {
            if ("contentType".equals(messageAttribute.getKey())) {
                messageHeaders.put("contentType", MimeType.valueOf((String)((MessageAttributeValue)messageAttribute.getValue()).getStringValue()));
                continue;
            }
            if ("id".equals(messageAttribute.getKey())) {
                messageHeaders.put("id", UUID.fromString(((MessageAttributeValue)messageAttribute.getValue()).getStringValue()));
                continue;
            }
            if ("String".equals(((MessageAttributeValue)messageAttribute.getValue()).getDataType())) {
                messageHeaders.put((String)messageAttribute.getKey(), ((MessageAttributeValue)messageAttribute.getValue()).getStringValue());
                continue;
            }
            if (((MessageAttributeValue)messageAttribute.getValue()).getDataType().startsWith("Number")) {
                Object numberValue = QueueMessageUtils.getNumberValue((MessageAttributeValue)messageAttribute.getValue());
                if (numberValue == null) continue;
                messageHeaders.put((String)messageAttribute.getKey(), numberValue);
                continue;
            }
            if (!"Binary".equals(((MessageAttributeValue)messageAttribute.getValue()).getDataType())) continue;
            messageHeaders.put((String)messageAttribute.getKey(), ((MessageAttributeValue)messageAttribute.getValue()).getBinaryValue());
        }
        return messageHeaders;
    }

    private static Object getNumberValue(MessageAttributeValue value) {
        String numberType = value.getDataType().substring("Number".length() + 1);
        try {
            Class<Number> numberTypeClass = Class.forName(numberType).asSubclass(Number.class);
            return NumberUtils.parseNumber((String)value.getStringValue(), numberTypeClass);
        }
        catch (ClassNotFoundException e) {
            throw new MessagingException(String.format("Message attribute with value '%s' and data type '%s' could not be converted into a Number because target class was not found.", value.getStringValue(), value.getDataType()), (Throwable)e);
        }
    }
}

