/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClient;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientFactoryBean;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingAmazonClient(value=AmazonSQS.class)
public class SqsClientConfiguration {
    @Autowired(required=false)
    private AWSCredentialsProvider awsCredentialsProvider;
    @Autowired(required=false)
    private RegionProvider regionProvider;

    @Lazy
    @Bean(destroyMethod="shutdown")
    public AmazonSQSBufferedAsyncClient amazonSQS() throws Exception {
        AmazonWebserviceClientFactoryBean clientFactoryBean = new AmazonWebserviceClientFactoryBean(AmazonSQSAsyncClient.class, this.awsCredentialsProvider, this.regionProvider);
        clientFactoryBean.afterPropertiesSet();
        return new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)clientFactoryBean.getObject());
    }
}

