/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.support;

import org.springframework.cloud.aws.messaging.config.annotation.NotificationMessage;
import org.springframework.cloud.aws.messaging.support.converter.NotificationRequestConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;

public class NotificationMessageArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter;

    public NotificationMessageArgumentResolver(MessageConverter converter) {
        this.converter = new NotificationRequestConverter(converter);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(NotificationMessage.class);
    }

    public Object resolveArgument(MethodParameter par, Message<?> msg) throws Exception {
        Object object = this.converter.fromMessage(msg, par.getParameterType());
        NotificationRequestConverter.NotificationRequest nr = (NotificationRequestConverter.NotificationRequest)object;
        return nr.getMessage();
    }
}

