/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import java.util.ArrayList;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.QueueMessageChannel;
import org.springframework.cloud.aws.messaging.core.support.AbstractMessageChannelMessagingSendingTemplate;
import org.springframework.cloud.aws.messaging.support.destination.DynamicQueueUrlDestinationResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.DestinationResolvingMessageReceivingOperations;
import org.springframework.util.ClassUtils;

public class QueueMessagingTemplate
extends AbstractMessageChannelMessagingSendingTemplate<QueueMessageChannel>
implements DestinationResolvingMessageReceivingOperations<QueueMessageChannel> {
    private final AmazonSQSAsync amazonSqs;
    private static final boolean JACKSON_2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)QueueMessagingTemplate.class.getClassLoader());

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs) {
        this(amazonSqs, null, null);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver) {
        this(amazonSqs, resourceIdResolver, null);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver, MessageConverter messageConverter) {
        super(new DynamicQueueUrlDestinationResolver((AmazonSQS)amazonSqs, resourceIdResolver));
        this.amazonSqs = amazonSqs;
        this.initMessageConverter(messageConverter);
    }

    private void initMessageConverter(MessageConverter messageConverter) {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(stringMessageConverter);
        if (messageConverter != null) {
            messageConverters.add(messageConverter);
        } else if (JACKSON_2_PRESENT) {
            MappingJackson2MessageConverter mappingJackson2MessageConverter = new MappingJackson2MessageConverter();
            mappingJackson2MessageConverter.setSerializedPayloadClass(String.class);
            messageConverters.add(mappingJackson2MessageConverter);
        }
        this.setMessageConverter((MessageConverter)new CompositeMessageConverter(messageConverters));
    }

    @Override
    protected QueueMessageChannel resolveMessageChannel(String physicalResourceIdentifier) {
        return new QueueMessageChannel(this.amazonSqs, physicalResourceIdentifier);
    }

    public Message<?> receive() throws MessagingException {
        return this.receive((QueueMessageChannel)((Object)this.getRequiredDefaultDestination()));
    }

    public Message<?> receive(QueueMessageChannel destination) throws MessagingException {
        return destination.receive();
    }

    public <T> T receiveAndConvert(Class<T> targetClass) throws MessagingException {
        return this.receiveAndConvert((QueueMessageChannel)((Object)this.getRequiredDefaultDestination()), targetClass);
    }

    public <T> T receiveAndConvert(QueueMessageChannel destination, Class<T> targetClass) throws MessagingException {
        Message<String> message = destination.receive();
        if (message != null) {
            return (T)this.getMessageConverter().fromMessage(message, targetClass);
        }
        return null;
    }

    public Message<?> receive(String destinationName) throws MessagingException {
        return ((QueueMessageChannel)((Object)this.resolveMessageChannelByLogicalName(destinationName))).receive();
    }

    public <T> T receiveAndConvert(String destinationName, Class<T> targetClass) throws MessagingException {
        QueueMessageChannel channel = (QueueMessageChannel)((Object)this.resolveMessageChannelByLogicalName(destinationName));
        return this.receiveAndConvert(channel, targetClass);
    }
}

