/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.listener;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.aws.messaging.listener.SqsMessageDeletionPolicy;
import org.springframework.cloud.aws.messaging.support.destination.DynamicQueueUrlDestinationResolver;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.core.CachingDestinationResolverProxy;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;

abstract class AbstractMessageListenerContainer
implements InitializingBean,
DisposableBean,
SmartLifecycle,
BeanNameAware {
    private static final String RECEIVING_ATTRIBUTES = "All";
    private static final String RECEIVING_MESSAGE_ATTRIBUTES = "All";
    private static final int DEFAULT_MAX_NUMBER_OF_MESSAGES = 10;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lifecycleMonitor = new Object();
    private final Map<String, QueueAttributes> registeredQueues = new HashMap<String, QueueAttributes>();
    private AmazonSQSAsync amazonSqs;
    private DestinationResolver<String> destinationResolver;
    private String beanName;
    private QueueMessageHandler messageHandler;
    private Integer maxNumberOfMessages;
    private Integer visibilityTimeout;
    private ResourceIdResolver resourceIdResolver;
    private Integer waitTimeOut;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private boolean active;
    private boolean running;

    AbstractMessageListenerContainer() {
    }

    protected Map<String, QueueAttributes> getRegisteredQueues() {
        return Collections.unmodifiableMap(this.registeredQueues);
    }

    protected QueueMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(QueueMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected Object getLifecycleMonitor() {
        return this.lifecycleMonitor;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected AmazonSQSAsync getAmazonSqs() {
        return this.amazonSqs;
    }

    public void setAmazonSqs(AmazonSQSAsync amazonSqs) {
        this.amazonSqs = amazonSqs;
    }

    protected DestinationResolver<String> getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver<String> destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    protected String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected Integer getMaxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }

    protected Integer getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    protected Integer getWaitTimeOut() {
        return this.waitTimeOut;
    }

    public void setWaitTimeOut(Integer waitTimeOut) {
        this.waitTimeOut = waitTimeOut;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            return this.active;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.validateConfiguration();
        this.initialize();
    }

    private void validateConfiguration() {
        Assert.state((this.amazonSqs != null ? 1 : 0) != 0, (String)"amazonSqs must not be null");
        Assert.state((this.messageHandler != null ? 1 : 0) != 0, (String)"messageHandler must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            if (this.destinationResolver == null) {
                this.destinationResolver = this.resourceIdResolver == null ? new CachingDestinationResolverProxy((DestinationResolver)new DynamicQueueUrlDestinationResolver((AmazonSQS)this.amazonSqs)) : new CachingDestinationResolverProxy((DestinationResolver)new DynamicQueueUrlDestinationResolver((AmazonSQS)this.amazonSqs, this.resourceIdResolver));
            }
            for (QueueMessageHandler.MappingInformation mappingInformation : this.messageHandler.getHandlerMethods().keySet()) {
                for (String queue : mappingInformation.getLogicalResourceIds()) {
                    this.registeredQueues.put(queue, this.queueAttributes(queue, mappingInformation.getDeletionPolicy()));
                }
            }
            this.active = true;
            this.getLifecycleMonitor().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.getLogger().debug("Starting container with name {}", (Object)this.getBeanName());
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            this.running = true;
            this.getLifecycleMonitor().notifyAll();
        }
        this.doStart();
    }

    private QueueAttributes queueAttributes(String queue, SqsMessageDeletionPolicy deletionPolicy) {
        String destinationUrl;
        try {
            destinationUrl = (String)this.getDestinationResolver().resolveDestination(queue);
        }
        catch (DestinationResolutionException e) {
            this.getLogger().warn(String.format("The queue with name '%s' does not exist.", queue), (Throwable)e);
            return null;
        }
        GetQueueAttributesResult queueAttributes = this.getAmazonSqs().getQueueAttributes(new GetQueueAttributesRequest(destinationUrl).withAttributeNames(new QueueAttributeName[]{QueueAttributeName.RedrivePolicy}));
        boolean hasRedrivePolicy = queueAttributes.getAttributes().containsKey(QueueAttributeName.RedrivePolicy.toString());
        return new QueueAttributes(hasRedrivePolicy, deletionPolicy, destinationUrl, this.getMaxNumberOfMessages(), this.getVisibilityTimeout(), this.getWaitTimeOut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.getLogger().debug("Stopping container with name {}", (Object)this.getBeanName());
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            this.running = false;
            this.getLifecycleMonitor().notifyAll();
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            this.active = false;
            this.doDestroy();
        }
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected void doDestroy() {
    }

    protected static class QueueAttributes {
        private final boolean hasRedrivePolicy;
        private final SqsMessageDeletionPolicy deletionPolicy;
        private final String destinationUrl;
        private final Integer maxNumberOfMessages;
        private final Integer visibilityTimeout;
        private final Integer waitTimeOut;

        public QueueAttributes(boolean hasRedrivePolicy, SqsMessageDeletionPolicy deletionPolicy, String destinationUrl, Integer maxNumberOfMessages, Integer visibilityTimeout, Integer waitTimeOut) {
            this.hasRedrivePolicy = hasRedrivePolicy;
            this.deletionPolicy = deletionPolicy;
            this.destinationUrl = destinationUrl;
            this.maxNumberOfMessages = maxNumberOfMessages;
            this.visibilityTimeout = visibilityTimeout;
            this.waitTimeOut = waitTimeOut;
        }

        public boolean hasRedrivePolicy() {
            return this.hasRedrivePolicy;
        }

        public ReceiveMessageRequest getReceiveMessageRequest() {
            ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.destinationUrl).withAttributeNames(new String[]{"All"}).withMessageAttributeNames(new String[]{"All"});
            if (this.maxNumberOfMessages != null) {
                receiveMessageRequest.withMaxNumberOfMessages(this.maxNumberOfMessages);
            } else {
                receiveMessageRequest.withMaxNumberOfMessages(Integer.valueOf(10));
            }
            if (this.visibilityTimeout != null) {
                receiveMessageRequest.withVisibilityTimeout(this.visibilityTimeout);
            }
            if (this.waitTimeOut != null) {
                receiveMessageRequest.setWaitTimeSeconds(this.waitTimeOut);
            }
            return receiveMessageRequest;
        }

        public SqsMessageDeletionPolicy getDeletionPolicy() {
            return this.deletionPolicy;
        }
    }
}

