/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.listener;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.Assert;

public class SendToHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler,
BeanFactoryAware {
    private final DestinationResolvingMessageSendingOperations<?> messageTemplate;
    private BeanFactory beanFactory;

    public SendToHandlerMethodReturnValueHandler(DestinationResolvingMessageSendingOperations<?> messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getMethodAnnotation(SendTo.class) != null;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        Assert.state((this.messageTemplate != null ? 1 : 0) != 0, (String)"A messageTemplate must be set to handle the return value.");
        if (this.getDestinationName(returnType) != null) {
            this.messageTemplate.convertAndSend(this.getDestinationName(returnType), returnValue);
        } else {
            this.messageTemplate.convertAndSend(returnValue);
        }
    }

    private String getDestinationName(MethodParameter returnType) {
        String[] destination = ((SendTo)returnType.getMethodAnnotation(SendTo.class)).value();
        return destination.length > 0 ? this.resolveName(destination[0]) : null;
    }

    private String resolveName(String name) {
        if (!(this.beanFactory instanceof ConfigurableBeanFactory)) {
            return name;
        }
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(name);
        BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
        if (exprResolver == null) {
            return name;
        }
        Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext(configurableBeanFactory, null));
        return result != null ? result.toString() : name;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

