/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.support.io;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageProtocolResolver;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Ordered;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.ResourceLoader;

public class SimpleStorageProtocolResolverConfigurer
implements BeanFactoryPostProcessor,
Ordered,
ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleStorageProtocolResolverConfigurer.class);
    private final ProtocolResolver protocolResolver;
    private ResourceLoader resourceLoader;

    public SimpleStorageProtocolResolverConfigurer(SimpleStorageProtocolResolver simpleStorageProtocolResolver) {
        this.protocolResolver = simpleStorageProtocolResolver;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (DefaultResourceLoader.class.isAssignableFrom(this.resourceLoader.getClass())) {
            ((DefaultResourceLoader)this.resourceLoader).addProtocolResolver(this.protocolResolver);
        } else {
            LOGGER.warn("The provided delegate resource loader is not an implementation of DefaultResourceLoader. Custom Protocol using s3:// prefix will not be enabled.");
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

