/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.annotation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.EC2MetadataUtils;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnAwsCloudEnvironmentCondition
implements ConfigurationCondition {
    private static final String EC2_METADATA_ROOT = "/latest/meta-data";
    private static Boolean isCloudEnvironment;

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (isCloudEnvironment == null) {
            try {
                isCloudEnvironment = EC2MetadataUtils.getData((String)"/latest/meta-data/instance-id", (int)1) != null;
            }
            catch (AmazonClientException e) {
                isCloudEnvironment = false;
            }
        }
        return isCloudEnvironment;
    }
}

